/*
 * Decompiled with CFR 0.152.
 */
package anon.client.replay;

import anon.IServiceContainer;
import anon.client.Multiplexer;
import anon.client.XmlControlChannel;
import anon.client.replay.ReplayTimestamp;
import anon.util.XMLParseException;
import anon.util.XMLUtil;
import java.util.Observable;
import java.util.Vector;
import logging.LogHolder;
import logging.LogType;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ReplayControlChannel
extends XmlControlChannel {
    private MessageDistributor m_messageDistributor = new MessageDistributor();
    private Object m_internalSynchronization = new Object();

    public ReplayControlChannel(Multiplexer a_multiplexer, IServiceContainer a_serviceContainer) {
        super(3, a_multiplexer, a_serviceContainer, false);
    }

    public Observable getMessageDistributor() {
        return this.m_messageDistributor;
    }

    protected void processXmlMessage(Document a_document) {
        try {
            LogHolder.log(7, LogType.NET, "Received a message: " + XMLUtil.toString(a_document));
            Element mixesNode = a_document.getDocumentElement();
            if (mixesNode == null) {
                throw new XMLParseException("##__root__##", "No document element in received XML structure.");
            }
            if (!mixesNode.getNodeName().equals("Mixes")) {
                throw new XMLParseException("##__root__##", "Mixes node expected in received XML structure.");
            }
            Vector<ReplayTimestamp> timestamps = new Vector<ReplayTimestamp>();
            NodeList mixNodes = mixesNode.getElementsByTagName("Mix");
            for (int i = 0; i < mixNodes.getLength(); ++i) {
                Element currentMixNode = (Element)mixNodes.item(i);
                String currentMixId = XMLUtil.parseAttribute((Node)currentMixNode, "id", null);
                if (currentMixId == null) {
                    throw new XMLParseException("##__null__##", "XML structure of Mix " + Integer.toString(i) + " does not contain a Mix-ID.");
                }
                NodeList currentReplayNodes = currentMixNode.getElementsByTagName("Replay");
                if (currentReplayNodes.getLength() == 0) {
                    throw new XMLParseException("##__null__##", "XML structure of Mix " + Integer.toString(i) + " does not contain a Replay node.");
                }
                NodeList currentReplayTimeStampNodes = ((Element)currentReplayNodes.item(0)).getElementsByTagName("ReplayTimestamp");
                if (currentReplayTimeStampNodes.getLength() == 0) {
                    throw new XMLParseException("##__null__##", "XML structure of Mix " + Integer.toString(i) + " does not contain a ReplayTimestamp node.");
                }
                int currentMixOffset = XMLUtil.parseAttribute(currentReplayTimeStampNodes.item(0), "offset", -1);
                if (currentMixOffset == -1) {
                    throw new XMLParseException("##__null__##", "XML structure of Mix " + Integer.toString(i) + " does not contain a valid ReplayTimestamp offset.");
                }
                int currentMixInterval = XMLUtil.parseAttribute(currentReplayTimeStampNodes.item(0), "interval", -1);
                if (currentMixInterval == -1) {
                    throw new XMLParseException("##__null__##", "XML structure of Mix " + Integer.toString(i) + " does not contain a valid ReplayTimestamp interval.");
                }
                timestamps.addElement(new ReplayTimestamp(currentMixId, currentMixInterval, currentMixOffset));
            }
            this.m_messageDistributor.publishTimestamps(timestamps);
        }
        catch (Exception e) {
            this.getServiceContainer().keepCurrentService(false);
            LogHolder.log(3, LogType.NET, e);
            this.m_messageDistributor.publishException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void requestTimestamps() {
        try {
            Document doc = XMLUtil.createDocument();
            if (doc == null) {
                throw new Exception("ReplayControlChannel: requestTimestamps(): Cannot create XML document for request.");
            }
            Element getTimestampsNode = doc.createElement("GetTimestamps");
            doc.appendChild(getTimestampsNode);
            int errorCode = 0;
            Object object = this.m_internalSynchronization;
            synchronized (object) {
                errorCode = this.sendXmlMessage(doc);
            }
            if (errorCode != 0) {
                throw new Exception("ReplayControlChannel: requestTimestamps(): Errorcode '" + Integer.toString(errorCode) + "' while sending request.");
            }
        }
        catch (Exception e) {
            LogHolder.log(3, LogType.NET, e);
            this.m_messageDistributor.publishException(e);
        }
    }

    private class MessageDistributor
    extends Observable {
        private MessageDistributor() {
        }

        public void publishTimestamps(Vector a_timestamps) {
            this.publishObject(a_timestamps);
        }

        public void publishException(Exception a_exception) {
            this.publishObject(a_exception);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void publishObject(Object a_object) {
            MessageDistributor messageDistributor = this;
            synchronized (messageDistributor) {
                this.setChanged();
                this.notifyObservers(a_object);
            }
        }
    }
}

