/*
 * Decompiled with CFR 0.152.
 */
package anon.mixminion.fec;

import anon.mixminion.fec.FECCode;
import anon.mixminion.fec.Pure16Code;
import anon.mixminion.fec.PureCode;

public class FECCodeFactory {
    protected FECCodeFactory() {
    }

    public FECCode createFECCode(int k, int n) {
        if (k < 1 || k > 65536 || n < k || n > 65536) {
            throw new IllegalArgumentException("k and n must be between 1 and 65536 and n must not be smaller than k: k=" + k + ",n=" + n);
        }
        if (n <= 256) {
            return new PureCode(k, n);
        }
        return new Pure16Code(k, n);
    }

    public static synchronized FECCodeFactory getDefault() {
        return new FECCodeFactory();
    }
}

