/*
 * Decompiled with CFR 0.152.
 */
package anon.pay;

import anon.AnonServerDescription;
import anon.IServiceContainer;
import anon.client.Multiplexer;
import anon.client.PacketCounter;
import anon.client.XmlControlChannel;
import anon.crypto.ByteSignature;
import anon.error.AnonServiceException;
import anon.error.ProtocolViolationException;
import anon.error.ServiceInterruptedException;
import anon.infoservice.ListenerInterface;
import anon.infoservice.MixCascade;
import anon.infoservice.MixPosition;
import anon.pay.IAIEventListener;
import anon.pay.PayAccount;
import anon.pay.PayAccountsFile;
import anon.pay.PaymentInstanceDBEntry;
import anon.pay.xml.NotRecoverableXMLError;
import anon.pay.xml.XMLAccountInfo;
import anon.pay.xml.XMLAiLoginConfirmation;
import anon.pay.xml.XMLChallenge;
import anon.pay.xml.XMLEasyCC;
import anon.pay.xml.XMLErrorMessage;
import anon.pay.xml.XMLPayRequest;
import anon.pay.xml.XMLPriceCertificate;
import anon.pay.xml.XMLResponse;
import anon.util.XMLUtil;
import java.sql.Timestamp;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Observable;
import java.util.Observer;
import java.util.Vector;
import logging.LogHolder;
import logging.LogType;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class AIControlChannel
extends XmlControlChannel {
    public static final long MAX_PREPAID_INTERVAL = 4000000L;
    public static final long MIN_PREPAID_INTERVAL = 5000L;
    public static final long AI_LOGIN_TIMEOUT = 120000L;
    private static final long MULTIPLE_LOGIN_BLOCK_TIME = 30000L;
    private static final int FIRST_MIX = 0;
    private static final String PREPAID_AMOUNT_IN_PAY_REQ_MIXVERSION = "00.08.42";
    public static final boolean REVERT_PRE_PREPAID = true;
    public static final Hashtable HASH_PREPAID_ON_SERVICES = new Hashtable();
    private int m_aiLogin_timeout = 30000;
    private XMLErrorMessage m_lastErrorMessage;
    private static long m_totalBytes = 0L;
    private boolean m_bPrepaidReceived = false;
    private long m_prepaidBytes = 0L;
    private boolean m_bMultiplexerClosed = false;
    private Vector m_aiListeners = new Vector();
    private PacketCounter m_packetCounter;
    private EmptyAccountPacketObserver m_packetCountEmptyObserver;
    private boolean m_bEmptyMessageSent = false;
    private MixCascade m_connectedCascade;
    private PayAccount m_payAccount;
    private XMLEasyCC m_initialCC;
    private final Vector m_aiLoginSyncObject = new Vector(1);
    private boolean m_prepaidAmountInPayRequest = false;
    private boolean m_bLastCCSignaled = false;

    public AIControlChannel(Multiplexer a_multiplexer, PacketCounter a_packetCounter, IServiceContainer a_serviceContainer, MixCascade a_connectedCascade) {
        super(2, a_multiplexer, a_serviceContainer, true);
        this.m_packetCounter = a_packetCounter;
        this.m_connectedCascade = a_connectedCascade;
        if (this.m_packetCounter == null) {
            throw new NullPointerException();
        }
        this.m_packetCountEmptyObserver = new EmptyAccountPacketObserver(this.m_connectedCascade.getConcatenatedPriceCertHashes());
        this.m_packetCounter.addObserver(this.m_packetCountEmptyObserver);
        String firstMixSoftwareVersion = this.m_connectedCascade.getMixInfo(0).getServiceSoftware().getVersion();
        if (firstMixSoftwareVersion != null) {
            // empty if block
        }
        LogHolder.log(6, LogType.PAY, "Mix " + this.m_connectedCascade.getMixInfo(0).getName() + (this.m_prepaidAmountInPayRequest ? " supports " : " does not support ") + "improved prepaid bytes negotiation.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addAIListener(IAIEventListener a_aiListener) {
        Vector vector = this.m_aiListeners;
        synchronized (vector) {
            if (!this.m_aiListeners.contains(a_aiListener)) {
                this.m_aiListeners.addElement(a_aiListener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processXmlMessage(Document docMsg) {
        block34: {
            Element elemRoot = docMsg.getDocumentElement();
            String tagName = elemRoot.getTagName();
            if (!(tagName.equals("ErrorMessage") || this.m_payAccount != null && this.m_payAccount.getCurrentCredit() > 0L)) {
                elemRoot = new XMLErrorMessage(10, this.m_payAccount, (AnonServerDescription)this.m_connectedCascade).toXmlElement(docMsg);
                tagName = "ErrorMessage";
            }
            try {
                if (tagName.equals(XMLPayRequest.XML_ELEMENT_NAME)) {
                    XMLPayRequest theRequest = new XMLPayRequest(elemRoot);
                    this.processPayRequest(theRequest);
                    break block34;
                }
                if (tagName.equals("LoginConfirmation")) {
                    XMLAiLoginConfirmation loginConfirm = new XMLAiLoginConfirmation(elemRoot);
                    Vector vector = this.m_aiLoginSyncObject;
                    synchronized (vector) {
                        if (loginConfirm.getCode() == 0) {
                            this.m_aiLoginSyncObject.addElement(new Object());
                        }
                        this.m_aiLoginSyncObject.notifyAll();
                        break block34;
                    }
                }
                if (tagName.equals("ErrorMessage")) {
                    PayAccountsFile payAccountsFile;
                    XMLErrorMessage error = new XMLErrorMessage(elemRoot, this.m_payAccount, (AnonServerDescription)this.m_connectedCascade);
                    LogHolder.log(2, LogType.PAY, "For account " + this.m_payAccount.getAccountNumber() + ", processing AI ErrorMessage " + error.getXmlErrorCode() + ": " + error.getMessage());
                    if (error.getXmlErrorCode() == 18 && error.getService() != null && error.getService() instanceof MixCascade) {
                        Vector vecListenerInterfaces = ((MixCascade)error.getService()).getListenerInterfaces();
                        for (int i = 0; vecListenerInterfaces != null && i < vecListenerInterfaces.size(); ++i) {
                            ((ListenerInterface)vecListenerInterfaces.elementAt(i)).blockInterface(30000L);
                        }
                    }
                    if (error.getXmlErrorCode() == 10 && !this.checkAccountChanged()) {
                        payAccountsFile = PayAccountsFile.getInstance();
                        synchronized (payAccountsFile) {
                            this.updateBalance(this.m_payAccount, false);
                            PayAccount currentAccount = PayAccountsFile.getInstance().getChargedAccount(this.m_connectedCascade.getPIID(), this.m_payAccount);
                            if (currentAccount != null) {
                                PayAccountsFile.getInstance().setActiveAccount(currentAccount);
                            } else {
                                if (!PayAccountsFile.getInstance().isAIAccountErrorIgnored()) {
                                    error = new NotRecoverableXMLError(error);
                                }
                                this.getServiceContainer().keepCurrentService(false);
                            }
                        }
                    } else if (error.getXmlErrorCode() == 21 && !this.checkAccountChanged()) {
                        this.m_payAccount.setBlocked(true);
                        payAccountsFile = PayAccountsFile.getInstance();
                        synchronized (payAccountsFile) {
                            PayAccount currentAccount = PayAccountsFile.getInstance().getChargedAccount(this.m_connectedCascade.getPIID());
                            if (currentAccount != null) {
                                PayAccountsFile.getInstance().setActiveAccount(currentAccount);
                            } else {
                                if (!PayAccountsFile.getInstance().isAIAccountErrorIgnored()) {
                                    error = new NotRecoverableXMLError(error);
                                }
                                this.getServiceContainer().keepCurrentService(false);
                            }
                        }
                    } else {
                        this.getServiceContainer().keepCurrentService(false);
                    }
                    this.m_lastErrorMessage = error;
                    if (error instanceof NotRecoverableXMLError) {
                        error = ((NotRecoverableXMLError)error).getSource();
                    }
                    PayAccountsFile.getInstance().signalAccountError(error);
                } else if (tagName.equals("Challenge")) {
                    this.processChallenge(new XMLChallenge(elemRoot));
                } else if (tagName.equals("CC")) {
                    this.processInitialCC(new XMLEasyCC(elemRoot));
                } else {
                    LogHolder.log(4, LogType.PAY, "Received unknown payment control channel message '" + tagName + "'");
                }
            }
            catch (Exception ex) {
                LogHolder.log(2, LogType.PAY, ex);
                this.getServiceContainer().keepCurrentService(false);
                PayAccountsFile.getInstance().signalAccountError(new XMLErrorMessage(6, ex.getClass().getName() + ": " + ex.getMessage(), this.m_payAccount, this.m_connectedCascade));
            }
        }
    }

    private synchronized void handlePrepaidBytesReceived(int prepaidBytes, PayAccount activeAccount) {
        if (activeAccount == null) {
            throw new NullPointerException("Active Account must not be null!");
        }
        if (prepaidBytes > 0 && !this.m_bPrepaidReceived) {
            this.m_prepaidBytes = prepaidBytes;
            PreviousPrepdaidBytes ppBytes = this.getPreviousPrepaidBytes();
            if (ppBytes != null && !ppBytes.m_dateTimeout.before(new Date())) {
                ppBytes.m_prepaidBytes = Math.max(0L, ppBytes.m_prepaidBytes - this.m_prepaidBytes);
            }
            this.m_bPrepaidReceived = true;
            activeAccount.updateCurrentBytes(prepaidBytes * -1);
        }
    }

    private synchronized void processChallenge(XMLChallenge chal) throws Exception {
        byte[] arbChal = chal.getChallengeForSigning();
        LogHolder.log(5, LogType.PAY, "Received " + chal.getPrepaidBytes() + " prepaid bytes.");
        if (chal.getType() != null && !chal.getType().equals("Mix")) {
            throw new Exception("Challenge has wrong type: " + chal.getType());
        }
        if (this.m_payAccount == null) {
            throw new Exception("Received Challenge from AI but ActiveAccount not set!");
        }
        if (!this.m_prepaidAmountInPayRequest) {
            this.handlePrepaidBytesReceived(chal.getPrepaidBytes(), this.m_payAccount);
        }
        byte[] arbSig = ByteSignature.sign(arbChal, this.m_payAccount.getPrivateKey());
        XMLResponse response = new XMLResponse(arbSig, null);
        this.sendXmlMessage(XMLUtil.toXMLDocument(response));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean checkAccountChanged() {
        if (this.m_payAccount == null || this.m_payAccount != PayAccountsFile.getInstance().getActiveAccount()) {
            Vector vector = this.m_aiListeners;
            synchronized (vector) {
                LogHolder.log(4, LogType.PAY, "Active account has changed while connected to paid service!");
                for (int i = 0; i < this.m_aiListeners.size(); ++i) {
                    ((IAIEventListener)this.m_aiListeners.elementAt(i)).accountChanged(this.m_payAccount, this.m_connectedCascade);
                }
            }
            return true;
        }
        return false;
    }

    private synchronized void processPayRequest(XMLPayRequest request) {
        if (this.checkAccountChanged()) {
            return;
        }
        if (request.isInitialCCRequest()) {
            if (this.m_prepaidAmountInPayRequest) {
                this.handlePrepaidBytesReceived(request.getPrepaidBytes(), this.m_payAccount);
            }
            this.processInitialCC(request.getCC());
            return;
        }
        if (request.isAccountRequest()) {
            try {
                this.sendAccountCert();
            }
            catch (AnonServiceException a_e) {
                LogHolder.log(1, LogType.PAY, "Could not send account certificate!", a_e);
            }
        }
        try {
            this.processCcToSign(request.getCC());
        }
        catch (Exception ex1) {
            LogHolder.log(3, LogType.PAY, ex1);
        }
    }

    private void updateBalance(final PayAccount currentAccount, final boolean a_bSynchronous) {
        if (currentAccount == null) {
            return;
        }
        Runnable runUpdate = new Runnable(){

            public void run() {
                try {
                    if (a_bSynchronous) {
                        currentAccount.fetchAccountInfo(false, 2000);
                    } else {
                        currentAccount.fetchAccountInfo(false);
                    }
                }
                catch (Exception ex) {
                    LogHolder.log(7, LogType.PAY, ex);
                }
            }
        };
        if (a_bSynchronous) {
            LogHolder.log(7, LogType.PAY, "Fetching new Balance from BI.");
            runUpdate.run();
        } else {
            LogHolder.log(7, LogType.PAY, "Fetching new Balance from BI asynchronously.");
            Thread t = new Thread(runUpdate);
            t.setDaemon(true);
            t.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void processCcToSign(XMLEasyCC cc) throws Exception {
        long transferedBytes;
        if (cc == null || cc.getConcatenatedPriceCertHashes() == null || !cc.getConcatenatedPriceCertHashes().equals(this.m_connectedCascade.getConcatenatedPriceCertHashes())) {
            return;
        }
        if (this.checkAccountChanged()) {
            throw new Exception("Active account has changed!");
        }
        if (this.m_payAccount == null || this.m_payAccount.getAccountNumber() != cc.getAccountNumber()) {
            throw new Exception("Received CC with wrong accountnumber");
        }
        this.m_payAccount.updateCurrentBytes(this.m_packetCounter);
        XMLEasyCC myLastCC = this.m_payAccount.getAccountInfo().getCC(cc.getConcatenatedPriceCertHashes());
        long confirmedBytes = 0L;
        if (myLastCC != null) {
            if (this.m_initialCC == null) {
                LogHolder.log(4, LogType.PAY, "No initial CC available! The Mix might have lost its CC.");
                if (this.m_prepaidBytes > 0L) {
                    this.m_payAccount.updateCurrentBytes(this.m_prepaidBytes);
                }
            } else {
                confirmedBytes = myLastCC.getTransferredBytes();
                LogHolder.log(7, LogType.PAY, "Transferred bytes of last CC: " + confirmedBytes);
            }
        }
        m_totalBytes = transferedBytes = this.m_payAccount.getCurrentBytes();
        long newPrepaidBytes = cc.getTransferredBytes() - transferedBytes;
        long diff = newPrepaidBytes - this.m_connectedCascade.getPrepaidInterval();
        if (diff > 0L) {
            LogHolder.log(4, LogType.PAY, "Illegal number of prepaid bytes for signing. Difference/Spent/CC/PrevCC: " + diff + "/" + transferedBytes + "/" + cc.getTransferredBytes() + "/" + confirmedBytes);
            if (transferedBytes < 0L) {
                LogHolder.log(4, LogType.PAY, "The mix might have lost a CC. Resetting transferred bytes to zero for now...");
                this.m_payAccount.updateCurrentBytes(transferedBytes * -1L);
                transferedBytes = this.m_payAccount.getCurrentBytes();
            } else if (cc.getTransferredBytes() < confirmedBytes) {
                LogHolder.log(4, LogType.PAY, "Requested less than confirmed before! Maybe a CC did get lost!");
            }
        }
        cc.setTransferredBytes(transferedBytes + this.m_connectedCascade.getPrepaidInterval());
        if (cc.getTransferredBytes() > confirmedBytes) {
            if (!this.m_bLastCCSignaled) {
                long lTransferred = cc.getTransferredBytes();
                long lRemaining = cc.getTransferredBytes();
                if (myLastCC != null) {
                    lRemaining -= myLastCC.getTransferredBytes();
                }
                if (this.m_payAccount.getCurrentCredit() < lRemaining) {
                    long lTotalToZero = this.m_payAccount.getCurrentCredit();
                    if (myLastCC != null) {
                        lTotalToZero += myLastCC.getTransferredBytes();
                    }
                    cc.setTransferredBytes(lTotalToZero);
                    cc.setLastCC(true);
                    this.m_bLastCCSignaled = true;
                    LogHolder.log(4, LogType.PAY, "For account " + this.m_payAccount.getAccountNumber() + ", " + lRemaining + " credits were requested. Should provide " + lTransferred + ", but can only provide " + lTotalToZero + ". Missing credits: " + (lTransferred - lTotalToZero));
                }
            }
            cc.setPriceCerts(this.m_connectedCascade.getPriceCertificateHashes());
            cc.setPIID(this.m_payAccount.getAccountCertificate().getPIID());
            cc.setCascadeID(this.m_connectedCascade.getId());
            cc.sign(this.m_payAccount.getPrivateKey());
            if (this.m_payAccount.addCostConfirmation(cc, true) <= 0L) {
                LogHolder.log(4, LogType.PAY, "Added old cost confirmation!");
            }
        } else if (myLastCC != null && this.m_initialCC != null) {
            cc = myLastCC;
        } else {
            LogHolder.log(0, LogType.PAY, "Creating zero CC!!");
            cc.setTransferredBytes(0L);
            cc.setPriceCerts(this.m_connectedCascade.getPriceCertificateHashes());
            cc.setPIID(this.m_payAccount.getAccountCertificate().getPIID());
            cc.setCascadeID(this.m_connectedCascade.getId());
            cc.sign(this.m_payAccount.getPrivateKey());
            this.m_payAccount.addCostConfirmation(cc, true);
        }
        if (this.m_initialCC == null) {
            LogHolder.log(5, LogType.PAY, "Seems to be the first connection to service. Setting initial CC to current CC...");
            this.m_initialCC = cc;
        }
        if (!this.m_payAccount.isCharged(new Timestamp(System.currentTimeMillis()))) {
            Vector vector = this.m_aiLoginSyncObject;
            synchronized (vector) {
                if (!this.m_bMultiplexerClosed) {
                    this.m_packetCountEmptyObserver.setEmpty();
                }
            }
        }
        this.sendXmlMessage(XMLUtil.toXMLDocument(cc));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendAccountCert() throws AnonServiceException {
        String message = null;
        Vector priceCerts = this.m_connectedCascade.getPriceCertificates();
        Timestamp now = new Timestamp(System.currentTimeMillis());
        if (this.m_payAccount != null) {
            throw new ProtocolViolationException(this.m_connectedCascade, "Account certificate already received!");
        }
        PayAccountsFile payAccountsFile = PayAccountsFile.getInstance();
        synchronized (payAccountsFile) {
            this.m_payAccount = PayAccountsFile.getInstance().getActiveAccount();
            if (this.m_payAccount == null || !this.m_payAccount.isCharged(now) || this.m_payAccount.getBI() == null || !this.m_payAccount.getBI().getId().equals(this.m_connectedCascade.getPIID())) {
                Vector accounts;
                PayAccount currentAccount = null;
                PayAccount openTransactionAccount = null;
                if (this.m_payAccount != null && this.m_payAccount.getCurrentSpent() == 0L) {
                    openTransactionAccount = PayAccountsFile.getInstance().getActiveAccount();
                }
                if ((accounts = PayAccountsFile.getInstance().getAccounts(this.m_connectedCascade.getPIID())).size() > 0) {
                    for (int i = 0; i < accounts.size() && !(currentAccount = (PayAccount)accounts.elementAt(i)).isCharged(now); ++i) {
                        if (!(openTransactionAccount != null || this.m_payAccount != null && this.m_payAccount.getCurrentSpent() != 0L || currentAccount.hasExpired())) {
                            openTransactionAccount = currentAccount;
                        }
                        currentAccount = null;
                    }
                    if (currentAccount != null) {
                        PayAccountsFile.getInstance().setActiveAccount(currentAccount);
                    } else if (openTransactionAccount != null) {
                        PayAccountsFile.getInstance().setActiveAccount(openTransactionAccount);
                    }
                    PayAccount activeAccount = PayAccountsFile.getInstance().getActiveAccount();
                    if (!(activeAccount != null && activeAccount.isCharged(now) && activeAccount.isSamePaymentInstance(this.m_connectedCascade.getPIID()) || accounts.size() <= 0)) {
                        LogHolder.log(4, LogType.PAY, "No charged account is available for connecting. Trying to update balances...");
                        for (int i = 0; i < accounts.size(); ++i) {
                            currentAccount = (PayAccount)accounts.elementAt(i);
                            if (currentAccount.canDoMonthlyOverusage(now)) {
                                PayAccountsFile.getInstance().setActiveAccount(currentAccount);
                                break;
                            }
                            if (currentAccount.getBalance() != null && !currentAccount.shouldUpdateAccountInfo()) continue;
                            this.updateBalance(currentAccount, false);
                            if (!currentAccount.isCharged(now)) continue;
                            PayAccountsFile.getInstance().setActiveAccount(currentAccount);
                            break;
                        }
                    }
                }
            }
            this.m_payAccount = PayAccountsFile.getInstance().getActiveAccount();
        }
        PayAccountsFile.getInstance().signalAccountRequest(this.m_connectedCascade);
        if (this.m_payAccount == null || this.m_payAccount.getCurrentCredit() <= 0L) {
            this.getServiceContainer().keepCurrentService(false);
            throw new XMLErrorMessage(10, "No active account is available! Cannot connect to paid cascade.", this.m_payAccount, this.m_connectedCascade);
        }
        if (priceCerts.size() != this.m_connectedCascade.getNumberOfMixes()) {
            message = "Not all Mixes in cascade " + this.m_connectedCascade.getId() + " have price certs! " + "PriceCerts/MixIDs:" + priceCerts.size() + "/" + this.m_connectedCascade.getNumberOfMixes();
        } else {
            for (int i = 0; i < this.m_connectedCascade.getNumberOfMixes(); ++i) {
                XMLPriceCertificate priceCert = (XMLPriceCertificate)priceCerts.elementAt(i);
                String mixID = this.m_connectedCascade.getMixId(i);
                PaymentInstanceDBEntry pi = this.m_payAccount.getBI();
                if (!priceCert.verify(pi)) {
                    message = "Price certificate of cascade " + this.m_connectedCascade.getId() + " for mix " + mixID + " cannot be verified for payment instance " + pi + " (" + this.m_payAccount.getPIID() + ")" + "!";
                    break;
                }
                if (priceCert.getSubjectKeyIdentifier().equals(mixID)) continue;
                message = "SKI in price certificate of cascade " + this.m_connectedCascade.getId() + " differs from Mix ID! SKI:" + priceCert.getSubjectKeyIdentifier() + " MixID: " + mixID;
                break;
            }
        }
        if (message != null) {
            LogHolder.log(3, LogType.PAY, message);
            this.getServiceContainer().keepCurrentService(false);
            PayAccountsFile.getInstance().signalAccountError(new XMLErrorMessage(17, message, this.m_payAccount, this.m_connectedCascade));
            throw new AnonServiceException(this.m_connectedCascade, message);
        }
        this.m_payAccount.resetCurrentBytes();
        this.sendXmlMessage(XMLUtil.toXMLDocument(this.m_payAccount.getAccountCertificate()));
        AnonServiceException error = null;
        Vector vector = this.m_aiLoginSyncObject;
        synchronized (vector) {
            LogHolder.log(6, LogType.PAY, "Performing new synchronous AI login");
            try {
                this.m_aiLoginSyncObject.wait(this.m_aiLogin_timeout);
            }
            catch (InterruptedException e) {
                error = new ServiceInterruptedException(this.m_connectedCascade);
            }
            if (this.m_aiLoginSyncObject.size() <= 0) {
                error = this.m_lastErrorMessage != null ? this.m_lastErrorMessage : new AnonServiceException(this.m_connectedCascade, "No login confirmation found!");
            }
            this.m_aiLoginSyncObject.removeAllElements();
        }
        if (error != null) {
            throw error;
        }
    }

    public static long getBytes() {
        return m_totalBytes;
    }

    private PreviousPrepdaidBytes getPreviousPrepaidBytes() {
        return (PreviousPrepdaidBytes)HASH_PREPAID_ON_SERVICES.get(this.m_connectedCascade.getConcatenatedPriceCertHashes() + this.m_payAccount.getAccountNumber());
    }

    private synchronized void processInitialCC(XMLEasyCC a_cc) {
        if (this.checkAccountChanged()) {
            return;
        }
        String msg = "AI has sent an INVALID last cost confirmation.";
        if (a_cc.verify(this.m_payAccount.getPublicKey())) {
            try {
                if (a_cc.getNrOfPriceCerts() != this.m_connectedCascade.getNrOfPriceCerts()) {
                    LogHolder.log(2, LogType.PAY, "number of price certificates in cost confirmation does not match number of price certs in cascade");
                    this.getServiceContainer().keepCurrentService(false);
                    PayAccountsFile.getInstance().signalAccountError(new XMLErrorMessage(17, "AI sent CC will illegal number of price certs" + a_cc.getNrOfPriceCerts(), this.m_payAccount, this.m_connectedCascade));
                    return;
                }
                Hashtable hashPriceCertHashesInCC = a_cc.getPriceCertHashes();
                Enumeration priceCertHashesInCascade = this.m_connectedCascade.getPriceCertificateHashes().keys();
                Hashtable inCascade = this.m_connectedCascade.getPriceCertificateHashes();
                int i = 0;
                while (priceCertHashesInCascade.hasMoreElements()) {
                    MixPosition ski = (MixPosition)priceCertHashesInCascade.nextElement();
                    String curCascadeHash = (String)inCascade.get(ski);
                    String curCcHash = (String)hashPriceCertHashesInCC.get(ski);
                    if (curCcHash == null || !curCascadeHash.equals(curCcHash)) {
                        String message = "AI sent CC with illegal price cert hash for mix " + (ski.getPosition() + 1) + " (" + (i + 1) + ")" + "!";
                        if (curCcHash == null) {
                            message = message + " Price certificate for this Mix was not found in CC!";
                        }
                        LogHolder.log(4, LogType.PAY, message);
                        this.getServiceContainer().keepCurrentService(false);
                        PayAccountsFile.getInstance().signalAccountError(new XMLErrorMessage(17, message, this.m_payAccount, this.m_connectedCascade));
                        return;
                    }
                    hashPriceCertHashesInCC.remove(ski);
                    ++i;
                }
                if (this.m_connectedCascade.getConcatenatedPriceCertHashes() == null || a_cc.getConcatenatedPriceCertHashes() == null || !this.m_connectedCascade.getConcatenatedPriceCertHashes().equals(a_cc.getConcatenatedPriceCertHashes())) {
                    PayAccountsFile.getInstance().signalAccountError(new XMLErrorMessage(17, "Price certificate hashes for a CC for service " + this.m_connectedCascade.getName() + " cannot be verified!", this.m_payAccount, this.m_connectedCascade));
                    return;
                }
                LogHolder.log(7, LogType.PAY, "AI has sent a valid last cost confirmation. Adding it to account.");
                if (this.m_initialCC == null) {
                    this.m_payAccount.updateCurrentBytes(a_cc.getTransferredBytes());
                    this.m_initialCC = a_cc;
                } else {
                    long diff = a_cc.getTransferredBytes() - this.m_initialCC.getTransferredBytes();
                    LogHolder.log(4, LogType.PAY, "Updated initial CostConfirmation! Difference: " + diff);
                    this.m_payAccount.updateCurrentBytes(diff);
                }
                long confirmedbytes = a_cc.getTransferredBytes();
                long diff = this.m_payAccount.addCostConfirmation(a_cc, true);
                if (diff < 0L) {
                    this.m_payAccount.updateCurrentBytes(diff);
                    LogHolder.log(4, LogType.PAY, "Received old cost confirmation!");
                } else if (diff > 0L) {
                    LogHolder.log(4, LogType.PAY, "Restored lost cost confirmation!");
                }
                long currentlyTransferedBytes = this.m_payAccount.getCurrentBytes();
                long bytesToPay = this.m_connectedCascade.getPrepaidInterval() - (confirmedbytes - currentlyTransferedBytes);
                long oldBytes = a_cc.getTransferredBytes();
                XMLEasyCC newCC = new XMLEasyCC(a_cc);
                if (bytesToPay > 0L) {
                    PreviousPrepdaidBytes ppBytes = this.getPreviousPrepaidBytes();
                    if (ppBytes != null) {
                        if (ppBytes.m_dateTimeout.before(new Date())) {
                            HASH_PREPAID_ON_SERVICES.remove(this.m_connectedCascade.getConcatenatedPriceCertHashes() + this.m_payAccount.getAccountNumber());
                            ppBytes = null;
                        } else if (ppBytes.m_prepaidBytes + this.m_prepaidBytes + bytesToPay > 4000000L) {
                            PayAccountsFile.getInstance().signalAccountError(new XMLErrorMessage(6, "The service " + this.m_connectedCascade.getName() + " requests too many prepaid bytes. From previous logins, we " + "have:" + ppBytes.m_prepaidBytes + " Now additionally: " + bytesToPay, this.m_payAccount, this.m_connectedCascade));
                            return;
                        }
                    }
                    if (this.m_payAccount.getCurrentCredit() < bytesToPay) {
                        long originBytesToPay = bytesToPay;
                        bytesToPay = this.m_payAccount.getCurrentCredit();
                        newCC.setLastCC(true);
                        this.m_bLastCCSignaled = true;
                        LogHolder.log(4, LogType.PAY, "For account " + this.m_payAccount.getAccountNumber() + ", " + originBytesToPay + " credits were requested. Should provide " + (confirmedbytes + originBytesToPay) + ", but can only provide " + (confirmedbytes + bytesToPay) + ". Missing credits: " + (originBytesToPay - bytesToPay));
                    }
                    newCC.setTransferredBytes(confirmedbytes + bytesToPay);
                } else {
                    newCC.setTransferredBytes(confirmedbytes);
                }
                this.m_prepaidBytes += bytesToPay;
                newCC.sign(this.m_payAccount.getPrivateKey());
                if (bytesToPay > 0L && this.m_payAccount.addCostConfirmation(newCC, true) <= 0L) {
                    LogHolder.log(4, LogType.PAY, "Sending old cost confirmation! Diff (ShouldBe)/Old/New:" + bytesToPay + "/" + oldBytes + "/" + newCC.getTransferredBytes());
                }
                this.sendXmlMessage(XMLUtil.toXMLDocument(newCC));
                return;
            }
            catch (Exception e) {
                LogHolder.log(2, LogType.PAY, msg, e);
            }
        } else {
            LogHolder.log(3, LogType.PAY, msg);
        }
        this.getServiceContainer().keepCurrentService(false);
        PayAccountsFile.getInstance().signalAccountError(new XMLErrorMessage(3, msg, this.m_payAccount, this.m_connectedCascade));
    }

    protected void finalize() throws Throwable {
        this.m_packetCounter.deleteObserver(this.m_packetCountEmptyObserver);
        super.finalize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void multiplexerClosed() {
        Vector vector = this.m_aiLoginSyncObject;
        synchronized (vector) {
            this.m_bMultiplexerClosed = true;
            this.m_packetCounter.deleteObserver(this.m_packetCountEmptyObserver);
            this.m_aiLoginSyncObject.notifyAll();
        }
        if (this.m_payAccount == null) {
            return;
        }
        XMLAccountInfo accountInfo = this.m_payAccount.getAccountInfo();
        if (accountInfo == null) {
            return;
        }
        XMLEasyCC myLastCC = accountInfo.getCC(this.m_connectedCascade.getConcatenatedPriceCertHashes());
        if (myLastCC == null) {
            return;
        }
        long lPrepaidBytes = myLastCC.getTransferredBytes() - this.m_payAccount.getCurrentBytes();
        if (lPrepaidBytes > 0L) {
            PreviousPrepdaidBytes ppBytes = this.getPreviousPrepaidBytes();
            if (ppBytes != null) {
                if (ppBytes.m_dateTimeout.before(new Date())) {
                    ppBytes.m_prepaidBytes = 0L;
                }
            } else {
                ppBytes = new PreviousPrepdaidBytes();
            }
            ppBytes.m_prepaidBytes += lPrepaidBytes;
            ppBytes.m_dateTimeout = new Date(System.currentTimeMillis() + 300000L);
            HASH_PREPAID_ON_SERVICES.put(this.m_connectedCascade.getConcatenatedPriceCertHashes() + this.m_payAccount.getAccountNumber(), ppBytes);
            int iLogLevel = 5;
            if (ppBytes.m_prepaidBytes > this.m_connectedCascade.getPrepaidInterval()) {
                iLogLevel = 4;
            }
            LogHolder.log(iLogLevel, LogType.MISC, "Stored " + ppBytes.m_prepaidBytes + " prepaid bytes for account " + this.m_payAccount.getAccountNumber() + " with current bytes " + this.m_payAccount.getCurrentBytes() + " while transferred " + myLastCC.getTransferredBytes() + " and reported prepaid " + this.m_prepaidBytes + " on service " + this.m_connectedCascade.getName() + " (" + this.m_connectedCascade.getConcatenatedPriceCertHashes() + ")" + " with prepaid interval " + this.m_connectedCascade.getPrepaidInterval());
        } else {
            LogHolder.log(1, LogType.MISC, "prepaid:" + this.m_prepaidBytes + " : " + lPrepaidBytes);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAILoginTimeout(int aiLogin_timeout) {
        Vector vector = this.m_aiLoginSyncObject;
        synchronized (vector) {
            this.m_aiLogin_timeout = aiLogin_timeout;
        }
    }

    public boolean isPrepaidAmountInPayRequest() {
        return this.m_prepaidAmountInPayRequest;
    }

    public void setPrepaidAmountInPayRequest(boolean prepaidAmountInPayRequest) {
        this.m_prepaidAmountInPayRequest = prepaidAmountInPayRequest;
    }

    private class PreviousPrepdaidBytes {
        private Date m_dateTimeout;
        private long m_prepaidBytes;

        private PreviousPrepdaidBytes() {
        }
    }

    private final class EmptyAccountPacketObserver
    implements Observer {
        private String m_concatenatedPCHashes;
        private boolean m_bEmpty = false;

        private EmptyAccountPacketObserver(String a_concatenatedPCHashes) {
            this.m_concatenatedPCHashes = a_concatenatedPCHashes;
        }

        public void setEmpty() {
            this.m_bEmpty = true;
        }

        public void update(Observable o, Object arg) {
            new Thread(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    AIControlChannel aIControlChannel = AIControlChannel.this;
                    synchronized (aIControlChannel) {
                        Vector vector = AIControlChannel.this.m_aiLoginSyncObject;
                        synchronized (vector) {
                            if (!AIControlChannel.this.m_bEmptyMessageSent) {
                                try {
                                    AIControlChannel.this.m_payAccount.updateCurrentBytes(AIControlChannel.this.m_packetCounter);
                                    XMLEasyCC myLastCC = AIControlChannel.this.m_payAccount.getAccountInfo().getCC(EmptyAccountPacketObserver.this.m_concatenatedPCHashes);
                                    long prepaidBytes = myLastCC.getTransferredBytes() - AIControlChannel.this.m_payAccount.getCurrentBytes();
                                    long diff = AIControlChannel.this.m_payAccount.getCurrentCreditCalculatedAlsoNegative();
                                    if (diff < 0L) {
                                        prepaidBytes += diff;
                                    }
                                    if (EmptyAccountPacketObserver.this.m_bEmpty || prepaidBytes < 1000000L) {
                                        // empty if block
                                    }
                                    if (!EmptyAccountPacketObserver.this.m_bEmpty || prepaidBytes > 0L) {
                                        return;
                                    }
                                }
                                catch (Exception a_e) {
                                    LogHolder.log(2, LogType.PAY, a_e);
                                }
                            }
                            PayAccountsFile.getInstance().signalAccountError(new XMLErrorMessage(10, AIControlChannel.this.m_payAccount, (AnonServerDescription)AIControlChannel.this.m_connectedCascade));
                            Vector vector2 = AIControlChannel.this.m_aiListeners;
                            synchronized (vector2) {
                                for (int i = 0; i < AIControlChannel.this.m_aiListeners.size(); ++i) {
                                    ((IAIEventListener)AIControlChannel.this.m_aiListeners.elementAt(i)).accountEmpty(AIControlChannel.this.m_payAccount, AIControlChannel.this.m_connectedCascade);
                                }
                                AIControlChannel.this.m_bEmptyMessageSent = true;
                            }
                        }
                    }
                }
            }).start();
        }
    }
}

