/*
 * Decompiled with CFR 0.152.
 */
package anon.proxy;

import anon.infoservice.IMutableProxyInterface;
import anon.infoservice.ImmutableProxyInterface;
import anon.proxy.DirectProxyConnection;
import anon.proxy.DirectProxyResponse;
import anon.util.BooleanVariable;
import anon.util.JAPMessages;
import anon.util.SocketGuard;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PushbackInputStream;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Observable;
import java.util.Observer;
import java.util.StringTokenizer;
import java.util.TimeZone;
import java.util.Vector;
import logging.LogHolder;
import logging.LogType;

public final class DirectProxy {
    private static final String GENERAL_RULE = "*";
    private static final int BUFFER_PUSHBACK = 2000;
    private static final String JONDOPROXY = "JonDoProxy";
    private static final String JONDOPROXY_ARG = "JonDoProxy".toLowerCase() + "=";
    private static final long TEMPORARY_REMEMBER_TIME_SECONDS = 5000L;
    private static final long TEMPORARY_REMEMBER_TIME = 10000L;
    private static final long TEMPORARY_REMEMBER_TIME_NO_WARNING = 10000L;
    private AllowProxyConnectionCallback m_callback;
    private IMutableProxyInterface m_proxyInterface = new IMutableProxyInterface.DummyMutableProxyInterface();
    private ServerSocket m_socketListener;
    private ServerSocket m_socketListenerTwo;
    private final Object THREAD_SYNC = new Object();
    private boolean m_bInterrupted = false;
    private volatile Thread threadRunLoop;
    private BooleanVariable m_bIsRunningOne = new BooleanVariable(false);
    private volatile Thread threadRunLoopTwo;
    private BooleanVariable m_bIsRunningTwo = new BooleanVariable(false);
    private final Hashtable rememberedDomains = new Hashtable();
    private final Object SYNC_CALLBACK = new Object();
    private final Vector m_vecThreads = new Vector();
    static /* synthetic */ Class class$anon$proxy$DirectProxy;

    public DirectProxy(ServerSocket a_socket, ServerSocket a_socketTwo, IMutableProxyInterface a_proxyInterface, AllowProxyConnectionCallback a_callback) {
        this.m_socketListener = a_socket;
        this.m_socketListenerTwo = a_socketTwo;
        if (a_proxyInterface != null) {
            this.m_proxyInterface = a_proxyInterface;
        }
        this.setAllowUnprotectedConnectionCallback(a_callback);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void setAllowUnprotectedConnectionCallback(AllowProxyConnectionCallback a_callback) {
        Hashtable hashtable = this.rememberedDomains;
        synchronized (hashtable) {
            if (this.m_callback != a_callback) {
                this.m_callback = a_callback;
                this.rememberedDomains.clear();
                if (this.m_callback != null) {
                    this.m_callback.setRulesChanged(false);
                    this.rememberedDomains.put(GENERAL_RULE, new RememberedRequestRight(GENERAL_RULE, true, System.currentTimeMillis() + 5000L));
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isConnected() {
        Object object = this.THREAD_SYNC;
        synchronized (object) {
            return this.threadRunLoop != null;
        }
    }

    public ServerSocket getSocketListener() {
        return this.m_socketListener;
    }

    public ServerSocket getSocketListenerTwo() {
        return this.m_socketListenerTwo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reset() {
        AllowProxyConnectionCallback callback = this.m_callback;
        if (callback != null) {
            callback.setRulesChanged(false);
        }
        Hashtable hashtable = this.rememberedDomains;
        synchronized (hashtable) {
            this.rememberedDomains.clear();
            this.rememberedDomains.put(GENERAL_RULE, new RememberedRequestRight(GENERAL_RULE, true, System.currentTimeMillis() + 5000L, false));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized boolean start() {
        if (this.m_socketListener == null) {
            return false;
        }
        Object object = this.THREAD_SYNC;
        synchronized (object) {
            if (this.threadRunLoop != null && this.threadRunLoop.isAlive()) {
                return true;
            }
            this.stop();
            this.reset();
            this.m_bInterrupted = false;
            LogHolder.log(4, LogType.NET, "Starting up direct proxy...");
            this.m_bIsRunningOne.set(true);
            this.threadRunLoop = new Thread((Runnable)new DirectProxyRunnable(this.m_socketListener, this.m_bIsRunningOne), "JAP - Direct Proxy");
            this.threadRunLoop.setDaemon(true);
            this.threadRunLoop.start();
            if (this.m_socketListenerTwo != null) {
                this.m_bIsRunningTwo.set(true);
                this.threadRunLoopTwo = new Thread((Runnable)new DirectProxyRunnable(this.m_socketListenerTwo, this.m_bIsRunningTwo), "JAP - Direct Proxy");
                this.threadRunLoopTwo.setDaemon(true);
                this.threadRunLoopTwo.start();
            }
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private RememberedRequestRight getRequestRight(RequestInfo requestInfo) {
        if (requestInfo == null) {
            return null;
        }
        Hashtable hashtable = this.rememberedDomains;
        synchronized (hashtable) {
            RememberedRequestRight requestRight = (RememberedRequestRight)this.rememberedDomains.get(requestInfo.getHost());
            if (requestRight == null) {
                requestRight = (RememberedRequestRight)this.rememberedDomains.get(GENERAL_RULE);
            }
            if (requestRight != null && requestRight.isTimedOut()) {
                this.rememberedDomains.remove(requestRight.getURI());
                requestRight = null;
            }
            return requestRight;
        }
    }

    public boolean allowDomain(URL a_url) {
        if (a_url == null) {
            return false;
        }
        RequestInfo info = DirectProxy.parseDomain(a_url.toString(), true, null);
        if (info == null) {
            return false;
        }
        RememberedRequestRight requestRight = new RememberedRequestRight(info.getHost(), false, Long.MAX_VALUE);
        this.rememberedDomains.put(requestRight.getURI(), requestRight);
        return true;
    }

    private static ServerSocket closeThread(Thread a_thread, ServerSocket a_socket, BooleanVariable a_bRunning) {
        if (a_thread == null) {
            return a_socket;
        }
        int i = 0;
        while (a_thread.isAlive()) {
            if (a_bRunning.isTrue()) {
                a_thread.interrupt();
            }
            Thread.yield();
            try {
                a_thread.join(250L);
            }
            catch (InterruptedException e) {
                // empty catch block
            }
            if (i > 10) {
                LogHolder.log(1, LogType.NET, "Shutting down direct proxy (" + (a_bRunning.isTrue() ? "Running" : "") + ") at " + a_socket.getInetAddress().getHostAddress() + ":" + a_socket.getLocalPort() + "...");
            }
            ++i;
        }
        return a_socket;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void stop() {
        Object object = this.THREAD_SYNC;
        synchronized (object) {
            if (this.threadRunLoop == null) {
                return;
            }
            LogHolder.log(4, LogType.NET, "Shutting down direct proxy...");
            this.m_bInterrupted = true;
            this.m_socketListener = DirectProxy.closeThread(this.threadRunLoop, this.m_socketListener, this.m_bIsRunningOne);
            this.m_socketListenerTwo = DirectProxy.closeThread(this.threadRunLoopTwo, this.m_socketListenerTwo, this.m_bIsRunningTwo);
            this.threadRunLoop = null;
            this.threadRunLoopTwo = null;
        }
    }

    protected ImmutableProxyInterface getProxyInterface() {
        return this.m_proxyInterface.getProxyInterface(false).getProxyInterface();
    }

    protected static RequestInfo parseDomain(String strURI, boolean a_bSecondLevelOnly, String a_strMethod) {
        int port = 80;
        if (strURI != null && strURI.length() > 0) {
            String strJDPArg = null;
            int index = strURI.indexOf("//");
            if (index > 0 && strURI.length() > 2) {
                strURI = strURI.substring(index + 2, strURI.length());
            }
            if ((index = strURI.indexOf("?")) > 0) {
                if (strURI.length() >= index + 3) {
                    strJDPArg = strURI.substring(index + 1, strURI.length());
                }
                strURI = strURI.substring(0, index);
                if (strJDPArg != null) {
                    index = strJDPArg.toLowerCase().indexOf(JONDOPROXY_ARG);
                    if (index >= 0 && strJDPArg.length() >= index + JONDOPROXY_ARG.length() + 1) {
                        if ((index = (strJDPArg = strJDPArg.substring(index + JONDOPROXY_ARG.length(), strJDPArg.length())).indexOf("&")) > 0) {
                            strJDPArg = strJDPArg.substring(0, index);
                        }
                    } else {
                        strJDPArg = null;
                    }
                } else {
                    strJDPArg = null;
                }
            }
            if ((index = strURI.indexOf("/")) > 0) {
                strURI = strURI.substring(0, index);
            }
            if ((index = strURI.lastIndexOf(":")) > 0 && strURI.length() > index + 1) {
                try {
                    port = Integer.parseInt(strURI.substring(index + 1, strURI.length()));
                }
                catch (NumberFormatException a_e) {
                    LogHolder.log(3, LogType.NET, "Could not parse port!", a_e);
                }
                strURI = strURI.substring(0, index);
            }
            while (strURI.endsWith("/")) {
                strURI = strURI.substring(0, strURI.length() - 1);
            }
            if (a_bSecondLevelOnly && (index = strURI.lastIndexOf(".")) > 0 && strURI.length() > index + 1) {
                try {
                    Integer.parseInt(strURI.substring(index + 1, strURI.length()));
                }
                catch (NumberFormatException a_e) {
                    StringTokenizer tokenizer = new StringTokenizer(strURI, ".");
                    while (tokenizer.countTokens() > 2) {
                        tokenizer.nextToken();
                    }
                    strURI = tokenizer.nextToken() + "." + tokenizer.nextToken();
                }
            }
            return new RequestInfo(strURI, a_strMethod, port, strJDPArg);
        }
        return null;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private final class DirectConViaHTTPProxy
    implements Runnable {
        private Socket m_clientSocket;
        private InputStream m_clientInputStream;

        public DirectConViaHTTPProxy(Socket a_clientSocket, InputStream a_clientInputStream) {
            this.m_clientSocket = a_clientSocket;
            this.m_clientInputStream = a_clientInputStream;
        }

        public void run() {
            try {
                int len;
                InputStream fromClient = this.m_clientInputStream != null ? this.m_clientInputStream : this.m_clientSocket.getInputStream();
                Socket serverSocket = new Socket(DirectProxy.this.getProxyInterface().getHost(), DirectProxy.this.getProxyInterface().getPort());
                DirectProxyResponse pr = new DirectProxyResponse(serverSocket.getInputStream(), this.m_clientSocket.getOutputStream());
                Thread responseThread = new Thread((Runnable)pr, "JAP - DirectProxyResponse");
                responseThread.start();
                OutputStream toProxy = serverSocket.getOutputStream();
                if (DirectProxy.this.getProxyInterface().isAuthenticationUsed()) {
                    String str = DirectProxyConnection.readLine(fromClient);
                    str = str + "\r\n";
                    toProxy.write(str.getBytes());
                    str = DirectProxy.this.getProxyInterface().getProxyAuthorizationHeaderAsString();
                    toProxy.write(str.getBytes());
                    toProxy.flush();
                }
                byte[] buff = new byte[1000];
                while ((len = fromClient.read(buff)) != -1) {
                    if (len <= 0) continue;
                    toProxy.write(buff, 0, len);
                    toProxy.flush();
                }
                responseThread.join();
                toProxy.close();
                fromClient.close();
                serverSocket.close();
            }
            catch (IOException ioe) {
            }
            catch (Exception e) {
                LogHolder.log(2, LogType.NET, "JAPDirectConViaProxy: Exception: " + e);
            }
        }
    }

    private final class RememberedRequestRight {
        private long m_timeRemembered;
        private boolean m_bWarn;
        private String m_URI;
        private boolean m_bUserAction;

        public RememberedRequestRight(String a_URI, boolean a_bWarn, long a_lTimeout) {
            this(a_URI, a_bWarn, a_lTimeout, true);
        }

        public RememberedRequestRight(String a_URI, boolean a_bWarn, long a_lTimeout, boolean a_bUserAction) {
            this.m_URI = a_URI;
            this.m_timeRemembered = a_lTimeout;
            this.m_bWarn = a_bWarn;
            this.m_bUserAction = a_bUserAction;
        }

        public boolean isUserAction() {
            return this.m_bUserAction;
        }

        public String getURI() {
            return this.m_URI;
        }

        public boolean isWarningShown() {
            return this.m_bWarn;
        }

        public long getCountDown() {
            if (this.m_timeRemembered == Long.MAX_VALUE) {
                return Long.MAX_VALUE;
            }
            long countDown = this.m_timeRemembered - System.currentTimeMillis();
            if (countDown < 0L) {
                countDown = 0L;
            }
            return countDown;
        }

        public boolean isTimedOut() {
            return this.m_timeRemembered < System.currentTimeMillis();
        }
    }

    private static final class SendAnonWarning
    implements Runnable {
        private static final String MSG_BLOCKED = (class$anon$proxy$DirectProxy == null ? (class$anon$proxy$DirectProxy = DirectProxy.class$("anon.proxy.DirectProxy")) : class$anon$proxy$DirectProxy).getName() + ".blocked";
        private static final String MSG_BLOCKED_ALL = (class$anon$proxy$DirectProxy == null ? (class$anon$proxy$DirectProxy = DirectProxy.class$("anon.proxy.DirectProxy")) : class$anon$proxy$DirectProxy).getName() + ".blockedAll";
        private static final String MSG_BLOCKED_DOMAIN = (class$anon$proxy$DirectProxy == null ? (class$anon$proxy$DirectProxy = DirectProxy.class$("anon.proxy.DirectProxy")) : class$anon$proxy$DirectProxy).getName() + ".blockedDomain";
        private static final String MSG_COUNTDOWN = (class$anon$proxy$DirectProxy == null ? (class$anon$proxy$DirectProxy = DirectProxy.class$("anon.proxy.DirectProxy")) : class$anon$proxy$DirectProxy).getName() + ".countdown";
        private static final String MSG_RELOAD = (class$anon$proxy$DirectProxy == null ? (class$anon$proxy$DirectProxy = DirectProxy.class$("anon.proxy.DirectProxy")) : class$anon$proxy$DirectProxy).getName() + ".reload";
        private static final String MSG_BLOCKED_PERMANENTLY = (class$anon$proxy$DirectProxy == null ? (class$anon$proxy$DirectProxy = DirectProxy.class$("anon.proxy.DirectProxy")) : class$anon$proxy$DirectProxy).getName() + ".blockedPermanently";
        private static final String MSG_ANON_MODE_OFF = (class$anon$proxy$DirectProxy == null ? (class$anon$proxy$DirectProxy = DirectProxy.class$("anon.proxy.DirectProxy")) : class$anon$proxy$DirectProxy).getName() + ".htmlAnonModeOff";
        private static final String MSG_ANON_MODE_OFF_BUT_FORCED = (class$anon$proxy$DirectProxy == null ? (class$anon$proxy$DirectProxy = DirectProxy.class$("anon.proxy.DirectProxy")) : class$anon$proxy$DirectProxy).getName() + ".htmlAnonModeOffButForced";
        private static final String MSG_CONNECTING = (class$anon$proxy$DirectProxy == null ? (class$anon$proxy$DirectProxy = DirectProxy.class$("anon.proxy.DirectProxy")) : class$anon$proxy$DirectProxy).getName() + ".connecting";
        private static final String MSG_ANONYMITY_MODE = (class$anon$proxy$DirectProxy == null ? (class$anon$proxy$DirectProxy = DirectProxy.class$("anon.proxy.DirectProxy")) : class$anon$proxy$DirectProxy).getName() + ".anonymityModeOff";
        private static final String MSG_WAIT_FOR_CONNECTION = (class$anon$proxy$DirectProxy == null ? (class$anon$proxy$DirectProxy = DirectProxy.class$("anon.proxy.DirectProxy")) : class$anon$proxy$DirectProxy).getName() + ".waitForConnection";
        private static final String MSG_WAIT_FOR_CONNECTION_2 = (class$anon$proxy$DirectProxy == null ? (class$anon$proxy$DirectProxy = DirectProxy.class$("anon.proxy.DirectProxy")) : class$anon$proxy$DirectProxy).getName() + ".waitForConnection2";
        private static final String MSG_HTML_ANON_MODE_SWITCH = (class$anon$proxy$DirectProxy == null ? (class$anon$proxy$DirectProxy = DirectProxy.class$("anon.proxy.DirectProxy")) : class$anon$proxy$DirectProxy).getName() + ".htmlAnonModeSwitch";
        private Socket socket;
        private SimpleDateFormat dateFormatHTTP;
        private InputStream m_clientInputStream;
        private RememberedRequestRight m_requestRight;
        private DirectProxy m_directProxy;
        private RequestInfo m_info;

        public SendAnonWarning(Socket s, InputStream a_clientInputStream, RememberedRequestRight a_requestRight, DirectProxy a_directProxy, RequestInfo a_info) {
            this.socket = s;
            this.m_info = a_info;
            this.m_directProxy = a_directProxy;
            this.m_requestRight = a_requestRight;
            this.m_clientInputStream = a_clientInputStream;
            this.dateFormatHTTP = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss zzz", Locale.US);
            this.dateFormatHTTP.setTimeZone(TimeZone.getTimeZone("GMT"));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Loose catch block
         */
        public void run() {
            block16: {
                try {
                    if (this.m_clientInputStream != null) {
                        this.m_clientInputStream.read();
                    } else {
                        this.socket.getInputStream().read();
                    }
                }
                catch (IOException a_e) {
                    // empty catch block
                }
                AllowProxyConnectionCallback callback = this.m_directProxy.m_callback;
                String applicationName = null;
                String string = applicationName = callback != null ? callback.getApplicationName() : "JonDo";
                if (applicationName == null) {
                    applicationName = "JonDo";
                }
                String date = this.dateFormatHTTP.format(new Date());
                BufferedWriter toClient = new BufferedWriter(new OutputStreamWriter(this.socket.getOutputStream()));
                toClient.write("HTTP/1.1 202 Accepted\r\n");
                toClient.write("Content-type: text/html; charset=UTF-8\r\n");
                toClient.write("Expires: " + date + "\r\n");
                toClient.write("Date: " + date + "\r\n");
                toClient.write("Pragma: no-cache\r\n");
                toClient.write("Cache-Control: no-cache\r\n\r\n");
                toClient.write("<HTML>\n<HEAD>\n<TITLE>" + applicationName + "</TITLE>\n" + "<meta http-equiv=\"Content-Type\" content=\"text/html; charset=utf-8\" />\n" + (this.m_info != null && this.m_info.getJonDoProxyArgument() != null ? "<meta http-equiv=\"JonDoProxy\" content=\"" + this.m_info.getJonDoProxyArgument() + "\" />\n" : "") + "</HEAD>\n<BODY>\n");
                toClient.write("<PRE>" + date + "</PRE>\n");
                toClient.flush();
                boolean bConnecting = callback != null && callback.isConnecting();
                String strAnonymityState = bConnecting ? JAPMessages.getString(MSG_CONNECTING).toUpperCase() : JAPMessages.getString(MSG_ANONYMITY_MODE) + " " + JAPMessages.getString("ngAnonOff").toUpperCase();
                strAnonymityState = applicationName + ": " + strAnonymityState;
                strAnonymityState = "<CENTER><H1>" + strAnonymityState + "</H1>";
                if (this.m_requestRight == null || callback == null || callback.isNonAnonymousAccessForbidden()) {
                    strAnonymityState = callback != null && callback.isConnecting() ? (callback.isNonAnonymousAccessForbidden() && callback.getAllowNonAnonymousSettingName() != null ? strAnonymityState + JAPMessages.getString(MSG_ANON_MODE_OFF, new String[]{JAPMessages.getString(callback.getAllowNonAnonymousSettingName()), "<BR>" + JAPMessages.getString(MSG_WAIT_FOR_CONNECTION), DirectProxy.JONDOPROXY}) : strAnonymityState + JAPMessages.getString(MSG_WAIT_FOR_CONNECTION_2)) : (callback != null && callback.getAllowNonAnonymousSettingName() != null && callback.isNonAnonymousAccessForbidden() ? strAnonymityState + JAPMessages.getString(MSG_ANON_MODE_OFF_BUT_FORCED, new String[]{JAPMessages.getString("ngAnonOn")}) + "<br><br>" + JAPMessages.getString(MSG_ANON_MODE_OFF, new String[]{JAPMessages.getString(callback.getAllowNonAnonymousSettingName()), "", DirectProxy.JONDOPROXY}) : strAnonymityState + JAPMessages.getString(MSG_ANON_MODE_OFF_BUT_FORCED, new String[]{JAPMessages.getString("ngAnonOn")}));
                    byte[] byWrite = (strAnonymityState + "</CENTER>").getBytes("UTF-8");
                    this.socket.getOutputStream().write(byWrite, 0, byWrite.length);
                } else {
                    long countDown = this.m_requestRight.getCountDown();
                    if (!bConnecting) {
                        strAnonymityState = strAnonymityState + JAPMessages.getString(MSG_ANON_MODE_OFF_BUT_FORCED, new String[]{JAPMessages.getString("ngAnonOn")}) + "<BR><BR>";
                    }
                    String blockedMessage = !this.m_requestRight.isUserAction() ? "" : (this.m_requestRight.getURI().equals(DirectProxy.GENERAL_RULE) ? JAPMessages.getString(MSG_BLOCKED_ALL) + "<BR>" : JAPMessages.getString(MSG_BLOCKED_DOMAIN, "<code>" + this.m_requestRight.getURI() + "</code>") + "<BR>");
                    Object[] addedMessage = countDown == Long.MAX_VALUE ? new String[]{bConnecting ? "<BR>" + JAPMessages.getString(MSG_WAIT_FOR_CONNECTION) : "", (bConnecting ? JAPMessages.getString(MSG_HTML_ANON_MODE_SWITCH, JAPMessages.getString("ngAnonOff")) : JAPMessages.getString(MSG_BLOCKED_PERMANENTLY)) + "<BR>" + JAPMessages.getString(MSG_RELOAD), DirectProxy.JONDOPROXY} : new String[]{bConnecting ? "<BR>" + JAPMessages.getString(MSG_WAIT_FOR_CONNECTION) : "", JAPMessages.getString(MSG_COUNTDOWN, new String[]{"" + countDown / 1000L, bConnecting ? JAPMessages.getString(MSG_HTML_ANON_MODE_SWITCH, JAPMessages.getString("ngAnonOff")) : JAPMessages.getString(MSG_BLOCKED_PERMANENTLY), "<BR>" + JAPMessages.getString(MSG_RELOAD)}), DirectProxy.JONDOPROXY};
                    byte[] byWrite = (strAnonymityState + blockedMessage + JAPMessages.getString(MSG_BLOCKED, addedMessage) + "</CENTER>").getBytes("UTF-8");
                    this.socket.getOutputStream().write(byWrite, 0, byWrite.length);
                }
                toClient.write("</BODY></HTML>\n");
                toClient.flush();
                toClient.close();
                Object var13_14 = null;
                try {
                    SocketGuard.close(this.socket);
                }
                catch (IOException a_e) {
                    LogHolder.log(3, LogType.NET, a_e);
                }
                break block16;
                {
                    catch (Exception e) {
                        LogHolder.log(2, LogType.NET, e);
                        Object var13_15 = null;
                        try {
                            SocketGuard.close(this.socket);
                        }
                        catch (IOException a_e) {
                            LogHolder.log(3, LogType.NET, a_e);
                        }
                    }
                }
                catch (Throwable throwable) {
                    Object var13_16 = null;
                    try {
                        SocketGuard.close(this.socket);
                    }
                    catch (IOException a_e) {
                        LogHolder.log(3, LogType.NET, a_e);
                    }
                    throw throwable;
                }
            }
        }
    }

    private class DirectProxyRunnable
    implements Runnable {
        private ServerSocket m_serverSocket;
        private BooleanVariable m_bRunning;

        public DirectProxyRunnable(ServerSocket a_serverSocket, BooleanVariable a_bRunning) {
            this.m_serverSocket = a_serverSocket;
            this.m_bRunning = a_bRunning;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            try {
                this.m_serverSocket.setSoTimeout(2000);
            }
            catch (Exception e1) {
                LogHolder.log(7, LogType.NET, "Could not set accept time out!", e1);
            }
            while (!DirectProxy.this.m_bInterrupted && !Thread.currentThread().isInterrupted()) {
                Socket socket = null;
                try {
                    socket = this.m_serverSocket.accept();
                }
                catch (InterruptedIOException e1) {
                    Thread.yield();
                    continue;
                }
                catch (SocketException e2) {
                    LogHolder.log(3, LogType.NET, "Accept socket exception: " + e2);
                    break;
                }
                catch (IOException a_e) {
                    LogHolder.log(2, LogType.NET, "Socket could not accept!" + a_e);
                    break;
                }
                if (DirectProxy.this.m_bInterrupted || Thread.currentThread().isInterrupted()) {
                    try {
                        SocketGuard.close(socket);
                    }
                    catch (IOException a_e) {
                        LogHolder.log(3, LogType.NET, a_e);
                    }
                    break;
                }
                try {
                    socket.setSoTimeout(0);
                }
                catch (SocketException soex) {
                    LogHolder.log(3, LogType.NET, "Could not set socket to blocking mode! Exception: " + soex);
                    try {
                        SocketGuard.close(socket);
                    }
                    catch (IOException a_e) {
                        LogHolder.log(3, LogType.NET, a_e);
                    }
                    socket = null;
                    continue;
                }
                if (DirectProxy.this.m_bInterrupted || Thread.currentThread().isInterrupted()) {
                    try {
                        SocketGuard.close(socket);
                    }
                    catch (IOException a_e) {
                        LogHolder.log(3, LogType.NET, a_e);
                    }
                    break;
                }
                ConnectionHandler connectionHandler = new ConnectionHandler(socket){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void run() {
                        this.handleConnection();
                        Vector vector = DirectProxy.this.m_vecThreads;
                        synchronized (vector) {
                            DirectProxy.this.m_vecThreads.removeElement(Thread.currentThread());
                            DirectProxy.this.m_vecThreads.notifyAll();
                        }
                    }
                };
                DirectProxy.this.m_vecThreads.addElement(connectionHandler);
                connectionHandler.start();
            }
            this.m_bRunning.set(false);
            LogHolder.log(5, LogType.NET, "Accept was stopped.");
            Vector vecThreads = (Vector)DirectProxy.this.m_vecThreads.clone();
            if (vecThreads.size() > 0) {
                LogHolder.log(4, LogType.NET, "Closing remaining threads...");
            }
            while (vecThreads.size() > 0) {
                LogHolder.log(4, LogType.NET, "Closing thread...");
                ConnectionHandler thread = (ConnectionHandler)vecThreads.lastElement();
                while (thread.isAlive()) {
                    LogHolder.log(4, LogType.NET, "Closing last thread from a total of " + vecThreads.size());
                    thread.interrupt();
                    thread.close();
                    Thread.yield();
                    LogHolder.log(6, LogType.NET, "Before sync...");
                    Vector vector = DirectProxy.this.m_vecThreads;
                    synchronized (vector) {
                        if (thread.isAlive()) {
                            try {
                                DirectProxy.this.m_vecThreads.wait(250L);
                            }
                            catch (InterruptedException e) {
                                // empty catch block
                            }
                        }
                    }
                }
                vecThreads.removeElement(thread);
                LogHolder.log(4, LogType.NET, "Thread closed. " + vecThreads.size() + " threads left.");
            }
            if (DirectProxy.this.m_vecThreads.size() > 0) {
                LogHolder.log(1, LogType.NET, "Possible insecurity or memory leak: Direct Proxy Server has " + DirectProxy.this.m_vecThreads.size() + " remaining threads!!");
            }
            LogHolder.log(6, LogType.NET, "Direct Proxy Server stopped.");
        }
    }

    private class ConnectionHandler
    extends Thread {
        private PushbackInputStream clientInputStream;
        private Socket m_clientSocket;

        public ConnectionHandler(Socket a_clientSocket) {
            this.m_clientSocket = a_clientSocket;
        }

        public synchronized void close() {
            try {
                SocketGuard.close(this.m_clientSocket);
            }
            catch (IOException e) {
                // empty catch block
            }
            try {
                if (this.clientInputStream != null) {
                    this.clientInputStream.close();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void handleConnection() {
            RememberedRequestRight requestRight;
            RequestInfo requestInfo;
            if (this.m_clientSocket == null) {
                return;
            }
            try {
                this.clientInputStream = new PushbackInputStream(this.m_clientSocket.getInputStream(), 2000);
            }
            catch (IOException ex) {
                LogHolder.log(3, LogType.NET, "Could not handle HTTP connection!", ex);
                this.close();
                return;
            }
            Object ex = this;
            synchronized (ex) {
                if (SocketGuard.isClosed(this.m_clientSocket)) {
                    LogHolder.log(3, LogType.NET, "Could not handle HTTP connection! Socket is closed.");
                    this.close();
                    return;
                }
            }
            ex = DirectProxy.this.rememberedDomains;
            synchronized (ex) {
                if (DirectProxy.this.m_callback == null || DirectProxy.this.m_callback.haveRulesChanged()) {
                    DirectProxy.this.rememberedDomains.clear();
                    if (DirectProxy.this.m_callback != null) {
                        DirectProxy.this.m_callback.setRulesChanged(false);
                    }
                }
                requestInfo = DirectProxyConnection.getURI(this.clientInputStream, 2000);
                requestRight = DirectProxy.this.getRequestRight(requestInfo);
            }
            if (requestInfo == null) {
                try {
                    SocketGuard.close(this.m_clientSocket);
                }
                catch (IOException e) {
                    LogHolder.log(3, LogType.NET, e);
                }
                try {
                    this.clientInputStream.close();
                }
                catch (IOException e) {
                    LogHolder.log(3, LogType.NET, e);
                }
                return;
            }
            if (requestInfo != null && requestRight == null) {
                Object object = DirectProxy.this.SYNC_CALLBACK;
                synchronized (object) {
                    AllowProxyConnectionCallback.Answer answer;
                    requestRight = DirectProxy.this.getRequestRight(requestInfo);
                    if (requestRight == null && (answer = DirectProxy.this.m_callback != null ? DirectProxy.this.m_callback.callback(requestInfo) : new AllowProxyConnectionCallback.Answer(false, false, false)) != null) {
                        long lTimeout = !answer.isTimedOut() ? Long.MAX_VALUE : (answer.isAllowed() ? System.currentTimeMillis() + 10000L : System.currentTimeMillis() + 10000L);
                        Hashtable hashtable = DirectProxy.this.rememberedDomains;
                        synchronized (hashtable) {
                            if (DirectProxy.this.m_callback == null || DirectProxy.this.m_callback.haveRulesChanged()) {
                                DirectProxy.this.rememberedDomains.clear();
                                if (DirectProxy.this.m_callback != null) {
                                    DirectProxy.this.m_callback.setRulesChanged(false);
                                }
                            }
                            if (answer.isRemembered()) {
                                if (answer.isTimedOut() && DirectProxy.this.m_callback != null && DirectProxy.this.m_callback.isAskedForAnyNonAnonymousRequest()) {
                                    lTimeout = System.currentTimeMillis() + 5000L;
                                }
                                requestRight = new RememberedRequestRight(DirectProxy.GENERAL_RULE, !answer.isAllowed(), lTimeout);
                            } else {
                                requestRight = new RememberedRequestRight(requestInfo.getHost(), !answer.isAllowed(), lTimeout);
                            }
                            DirectProxy.this.rememberedDomains.put(requestRight.getURI(), requestRight);
                        }
                    }
                }
            }
            if (requestRight != null && !requestRight.isWarningShown()) {
                if (DirectProxy.this.getProxyInterface() != null && DirectProxy.this.getProxyInterface().isValid() && DirectProxy.this.getProxyInterface().getProtocol() == 1) {
                    new DirectConViaHTTPProxy(this.m_clientSocket, this.clientInputStream).run();
                } else {
                    new DirectProxyConnection(this.m_clientSocket, this.clientInputStream, DirectProxy.this);
                }
            } else {
                new SendAnonWarning(this.m_clientSocket, this.clientInputStream, requestRight, DirectProxy.this, requestInfo).run();
            }
        }
    }

    public static abstract class AllowProxyConnectionCallback
    implements Observer {
        public static final String RULES_CHANGED_OBSERVABLE_NOTIFIER = "RulesChanged";
        private boolean m_bRulesChanged = false;

        public abstract boolean isConnecting();

        public boolean haveRulesChanged() {
            return this.m_bRulesChanged;
        }

        public URL getHTMLHelpPath() {
            return null;
        }

        private void setRulesChanged(boolean a_bChanged) {
            this.m_bRulesChanged = a_bChanged;
        }

        public void update(Observable o, Object arg) {
            if (arg != null && arg == RULES_CHANGED_OBSERVABLE_NOTIFIER) {
                this.m_bRulesChanged = true;
            }
        }

        public abstract boolean isNonAnonymousAccessForbidden();

        public abstract String getApplicationName();

        public abstract String getAllowNonAnonymousSettingName();

        public abstract boolean isAskedForAnyNonAnonymousRequest();

        public abstract Answer callback(RequestInfo var1);

        public static class Answer {
            private boolean m_bRemembered;
            private boolean m_bAllow;
            private boolean m_bTimeout;

            public Answer(boolean a_bAllow, boolean a_bRemembered, boolean a_bTimeout) {
                this.m_bAllow = a_bAllow;
                this.m_bRemembered = a_bRemembered;
                this.m_bTimeout = a_bTimeout;
            }

            public boolean isRemembered() {
                return this.m_bRemembered;
            }

            public boolean isTimedOut() {
                return this.m_bTimeout;
            }

            public boolean isAllowed() {
                return this.m_bAllow;
            }
        }
    }

    public static class RequestInfo {
        private String m_strURI;
        private String m_strMethod;
        private int m_port;
        private String m_jdpArg;

        protected RequestInfo(String a_strURI, String a_strMethod, int a_port, String a_jdpArg) {
            this.m_strURI = a_strURI;
            this.m_strMethod = a_strMethod;
            this.m_port = a_port;
            this.m_jdpArg = a_jdpArg;
        }

        public String getJonDoProxyArgument() {
            return this.m_jdpArg;
        }

        public String getHost() {
            return this.m_strURI;
        }

        public String getMethod() {
            return this.m_strMethod;
        }

        public int getPort() {
            return this.m_port;
        }
    }
}

