/*
 * Decompiled with CFR 0.152.
 */
package anon.crypto;

import anon.crypto.AbstractX509Extension;
import anon.crypto.X509DistinguishedName;
import anon.util.Util;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.Vector;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x509.Extension;
import org.bouncycastle.asn1.x509.GeneralName;
import org.bouncycastle.asn1.x509.GeneralNames;

public class X509CertificateIssuer
extends AbstractX509Extension {
    public static final String IDENTIFIER = Extension.certificateIssuer.getId();
    private X509DistinguishedName m_issuer;

    public X509CertificateIssuer(X509DistinguishedName a_issuer) {
        super(IDENTIFIER, true, X509CertificateIssuer.createDEROctets(a_issuer));
        this.m_issuer = a_issuer;
    }

    public X509CertificateIssuer(ASN1Sequence a_extension) {
        super(a_extension);
        this.createValue();
    }

    private static byte[] createDEROctets(X509DistinguishedName a_issuer) {
        try {
            return new GeneralNames(new GeneralName(a_issuer.getX500Name())).getEncoded("DER");
        }
        catch (IOException e) {
            return null;
        }
    }

    public String getName() {
        return "CertificateIssuer";
    }

    private void createValue() {
        try {
            ASN1InputStream in = new ASN1InputStream(new ByteArrayInputStream(this.getDEROctets()));
            ASN1Sequence seq = (ASN1Sequence)in.readObject();
            in.close();
            GeneralName name = GeneralNames.getInstance(seq).getNames()[0];
            if (name.getTagNo() != 4) {
                throw new Exception();
            }
            seq = (DERSequence)name.getName();
            this.m_issuer = new X509DistinguishedName(X500Name.getInstance(seq));
        }
        catch (Exception e) {
            throw new RuntimeException("Could not read certificate issuer extension from byte array!");
        }
    }

    public Vector getValues() {
        return Util.toVector(this.m_issuer.toString());
    }

    public boolean equalsIssuer(Object a_object) {
        return this.m_issuer.equals(a_object);
    }

    public X509DistinguishedName getDistinguishedName() {
        return this.m_issuer;
    }
}

