/*
 * Decompiled with CFR 0.152.
 */
package HTTPClient;

import HTTPClient.Request;
import HTTPClient.Util;
import java.util.Enumeration;
import java.util.Hashtable;

class IdempotentSequence {
    private static final int UNKNOWN = 0;
    private static final int HEAD = 1;
    private static final int GET = 2;
    private static final int POST = 3;
    private static final int PUT = 4;
    private static final int DELETE = 5;
    private static final int OPTIONS = 6;
    private static final int TRACE = 7;
    private int[] m_history;
    private String[] r_history;
    private int m_len = 0;
    private int r_len = 0;
    private boolean analysis_done = false;
    private Hashtable threads = new Hashtable();
    private static final Object INDET = new Object();

    public IdempotentSequence() {
        this.m_history = new int[10];
        this.r_history = new String[10];
    }

    public void add(Request req) {
        if (this.m_len >= this.m_history.length) {
            this.m_history = Util.resizeArray(this.m_history, this.m_history.length + 10);
        }
        this.m_history[this.m_len++] = IdempotentSequence.methodNum(req.getMethod());
        if (this.r_len >= this.r_history.length) {
            this.r_history = Util.resizeArray(this.r_history, this.r_history.length + 10);
        }
        this.r_history[this.r_len++] = req.getRequestURI();
    }

    public boolean isIdempotent(Request req) {
        if (!this.analysis_done) {
            this.do_analysis();
        }
        return (Boolean)this.threads.get(req.getRequestURI());
    }

    private void do_analysis() {
        int idx = 0;
        while (idx < this.r_len) {
            Object t_state = this.threads.get(this.r_history[idx]);
            if (this.m_history[idx] == 0) {
                this.threads.put(this.r_history[idx], Boolean.FALSE);
            } else if (t_state == null) {
                if (IdempotentSequence.methodHasSideEffects(this.m_history[idx]) && IdempotentSequence.methodIsComplete(this.m_history[idx])) {
                    this.threads.put(this.r_history[idx], Boolean.TRUE);
                } else {
                    this.threads.put(this.r_history[idx], INDET);
                }
            } else if (t_state == INDET && IdempotentSequence.methodHasSideEffects(this.m_history[idx])) {
                this.threads.put(this.r_history[idx], Boolean.FALSE);
            }
            ++idx;
        }
        Enumeration te = this.threads.keys();
        while (te.hasMoreElements()) {
            String res = (String)te.nextElement();
            if (this.threads.get(res) != INDET) continue;
            this.threads.put(res, Boolean.TRUE);
        }
    }

    public static boolean methodIsIdempotent(String method) {
        return IdempotentSequence.methodIsIdempotent(IdempotentSequence.methodNum(method));
    }

    private static boolean methodIsIdempotent(int method) {
        switch (method) {
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                return true;
            }
        }
        return false;
    }

    public static boolean methodIsComplete(String method) {
        return IdempotentSequence.methodIsComplete(IdempotentSequence.methodNum(method));
    }

    private static boolean methodIsComplete(int method) {
        switch (method) {
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                return true;
            }
        }
        return false;
    }

    public static boolean methodHasSideEffects(String method) {
        return IdempotentSequence.methodHasSideEffects(IdempotentSequence.methodNum(method));
    }

    private static boolean methodHasSideEffects(int method) {
        switch (method) {
            case 1: 
            case 2: 
            case 6: 
            case 7: {
                return false;
            }
        }
        return true;
    }

    private static int methodNum(String method) {
        if (method.equals("GET")) {
            return 2;
        }
        if (method.equals("POST")) {
            return 3;
        }
        if (method.equals("HEAD")) {
            return 1;
        }
        if (method.equals("PUT")) {
            return 4;
        }
        if (method.equals("DELETE")) {
            return 5;
        }
        if (method.equals("OPTIONS")) {
            return 6;
        }
        if (method.equals("TRACE")) {
            return 7;
        }
        return 0;
    }
}

