/*
 * Decompiled with CFR 0.152.
 */
package anon.crypto;

import anon.crypto.AsymmetricCryptoKeyPair;
import anon.crypto.ICertificate;
import anon.crypto.IMyPrivateKey;
import anon.crypto.IMyPublicKey;
import anon.crypto.JAPCertificate;
import anon.crypto.MyX509Extensions;
import anon.crypto.PKCS10CertificationRequest;
import anon.crypto.Validity;
import anon.crypto.X509DistinguishedName;
import anon.crypto.X509SubjectKeyIdentifier;
import anon.util.Base64;
import anon.util.IMiscPasswordReader;
import anon.util.ResourceLoader;
import anon.util.SingleStringPasswordReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigInteger;
import java.security.SecureRandom;
import java.util.Enumeration;
import java.util.Vector;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.ASN1Set;
import org.bouncycastle.asn1.ASN1TaggedObject;
import org.bouncycastle.asn1.BERConstructedOctetString;
import org.bouncycastle.asn1.BEROutputStream;
import org.bouncycastle.asn1.DERBMPString;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.DEROutputStream;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.DERSet;
import org.bouncycastle.asn1.pkcs.AuthenticatedSafe;
import org.bouncycastle.asn1.pkcs.CertBag;
import org.bouncycastle.asn1.pkcs.ContentInfo;
import org.bouncycastle.asn1.pkcs.EncryptedData;
import org.bouncycastle.asn1.pkcs.EncryptedPrivateKeyInfo;
import org.bouncycastle.asn1.pkcs.MacData;
import org.bouncycastle.asn1.pkcs.PKCS12PBEParams;
import org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.bouncycastle.asn1.pkcs.Pfx;
import org.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import org.bouncycastle.asn1.pkcs.SafeBag;
import org.bouncycastle.asn1.pkcs.SignedData;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.asn1.x509.Certificate;
import org.bouncycastle.asn1.x509.DigestInfo;
import org.bouncycastle.asn1.x509.SubjectKeyIdentifier;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.bouncycastle.asn1.x509.X509ObjectIdentifiers;
import org.bouncycastle.crypto.BlockCipher;
import org.bouncycastle.crypto.BufferedBlockCipher;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.PBEParametersGenerator;
import org.bouncycastle.crypto.digests.SHA1Digest;
import org.bouncycastle.crypto.engines.DESedeEngine;
import org.bouncycastle.crypto.engines.RC2Engine;
import org.bouncycastle.crypto.generators.PKCS12ParametersGenerator;
import org.bouncycastle.crypto.macs.HMac;
import org.bouncycastle.crypto.modes.CBCBlockCipher;
import org.bouncycastle.crypto.paddings.PaddedBufferedBlockCipher;
import org.bouncycastle.crypto.params.DESParameters;
import org.bouncycastle.crypto.params.KeyParameter;
import org.bouncycastle.crypto.params.ParametersWithIV;
import org.bouncycastle.crypto.params.ParametersWithRandom;

public final class PKCS12
implements PKCSObjectIdentifiers,
X509ObjectIdentifiers,
ICertificate {
    public static final String FILE_EXTENSION = ".pfx";
    private static final int SALT_SIZE = 20;
    private static final int MIN_ITERATIONS = 100;
    private static final String BASE64_TAG = "PKCS12";
    public static final String XML_ELEMENT_NAME = "X509PKCS12";
    private static final String KEY_ALGORITHM = "1.2.840.113549.1.12.1.3";
    private static final String CERT_ALGORITHM = "1.2.840.113549.1.12.1.6";
    private SecureRandom random = new SecureRandom();
    private AsymmetricCryptoKeyPair m_keyPair;
    private JAPCertificate m_x509certificate;

    public PKCS12(X509DistinguishedName a_ownerAlias, AsymmetricCryptoKeyPair a_keyPair, Validity a_validity) {
        this(a_ownerAlias, a_keyPair, a_validity, null);
    }

    public PKCS12(X509DistinguishedName a_ownerAlias, AsymmetricCryptoKeyPair a_keyPair, Validity a_validity, MyX509Extensions a_extensions) {
        this.m_keyPair = a_keyPair;
        this.m_x509certificate = JAPCertificate.getInstance(a_ownerAlias, a_keyPair, a_validity, a_extensions);
    }

    private PKCS12(AsymmetricCryptoKeyPair a_keyPair, JAPCertificate a_X509certificate) {
        this.m_keyPair = a_keyPair;
        this.m_x509certificate = a_X509certificate;
    }

    public static PKCS12 getInstance(byte[] a_bytes, char[] a_password) {
        return PKCS12.getInstance(a_bytes, (IMiscPasswordReader)new SingleStringPasswordReader(a_password));
    }

    public static PKCS12 getInstance(byte[] a_bytes, String a_password) {
        return PKCS12.getInstance(a_bytes, (IMiscPasswordReader)new SingleStringPasswordReader(a_password));
    }

    public static PKCS12 getInstance(String privCertString, String password) {
        return PKCS12.getInstance(privCertString.getBytes(), password.toCharArray());
    }

    public static PKCS12 getInstance(byte[] a_bytes, IMiscPasswordReader a_passwordReader) {
        if (a_bytes == null) {
            return null;
        }
        return PKCS12.getInstance((InputStream)new ByteArrayInputStream(a_bytes), a_passwordReader);
    }

    public static PKCS12 getInstance(InputStream a_stream, char[] password) {
        return PKCS12.getInstance(a_stream, (IMiscPasswordReader)new SingleStringPasswordReader(password));
    }

    public static PKCS12 getInstance(InputStream a_stream, String password) {
        return PKCS12.getInstance(a_stream, (IMiscPasswordReader)new SingleStringPasswordReader(password));
    }

    public static PKCS12 getInstance(InputStream a_stream, IMiscPasswordReader a_passwordReader) {
        boolean bCorrectPassword = false;
        char[] password = new char[]{};
        if (a_passwordReader == null) {
            a_passwordReader = new SingleStringPasswordReader(new char[0]);
        }
        try {
            String alias = null;
            IMyPrivateKey privKey = null;
            Certificate x509cert = null;
            ASN1Sequence asn1seq = JAPCertificate.toASN1Sequence(ResourceLoader.getStreamAsBytes(a_stream), XML_ELEMENT_NAME);
            if (asn1seq == null) {
                return null;
            }
            ContentInfo contentInfo = Pfx.getInstance(asn1seq).getAuthSafe();
            if (!contentInfo.getContentType().equals(PKCSObjectIdentifiers.data)) {
                return null;
            }
            ASN1InputStream is = new ASN1InputStream(new ByteArrayInputStream(((ASN1OctetString)contentInfo.getContent()).getOctets()));
            ContentInfo[] cinfos = AuthenticatedSafe.getInstance((ASN1Sequence)is.readObject()).getContentInfo();
            for (int i = 0; i < cinfos.length; ++i) {
                ASN1Sequence cseq;
                if (cinfos[i].getContentType().equals(PKCSObjectIdentifiers.data)) {
                    ASN1InputStream dis = new ASN1InputStream(new ByteArrayInputStream(((ASN1OctetString)cinfos[i].getContent()).getOctets()));
                    cseq = (ASN1Sequence)dis.readObject();
                } else {
                    if (!cinfos[i].getContentType().equals(PKCSObjectIdentifiers.encryptedData)) continue;
                    EncryptedData ed = EncryptedData.getInstance((ASN1Sequence)cinfos[i].getContent());
                    String algId = ed.getEncryptionAlgorithm().getAlgorithm().getId();
                    MyCipher cipher = PKCS12.getCipher(algId);
                    if (cipher == null) {
                        return null;
                    }
                    PKCS12PBEParams pbeParams = PKCS12PBEParams.getInstance((ASN1Sequence)ed.getEncryptionAlgorithm().getParameters());
                    FilterInputStream bis = null;
                    do {
                        try {
                            bis = new ASN1InputStream(new ByteArrayInputStream(PKCS12.codeData(false, ed.getContent().getOctets(), pbeParams, password, cipher.cipher, cipher.keysize)));
                            cseq = (ASN1Sequence)((ASN1InputStream)bis).readObject();
                            bis.close();
                            bCorrectPassword = true;
                        }
                        catch (Throwable a_e) {
                            cseq = null;
                            bis.close();
                            password = password.length == 0 ? new char[]{'\u0000'} : a_passwordReader.readPassword(null).toCharArray();
                        }
                    } while (!bCorrectPassword);
                }
                for (int j = 0; j < cseq.size(); ++j) {
                    ASN1InputStream dIn;
                    SafeBag sb = SafeBag.getInstance((ASN1Sequence)cseq.getObjectAt(j));
                    if (sb.getBagId().equals(PKCSObjectIdentifiers.certBag)) {
                        dIn = new ASN1InputStream(new ByteArrayInputStream(((ASN1OctetString)CertBag.getInstance((ASN1Sequence)sb.getBagValue()).getCertValue()).getOctets()));
                        ASN1Sequence xseq = (ASN1Sequence)dIn.readObject();
                        x509cert = xseq.size() > 1 && xseq.getObjectAt(1) instanceof ASN1ObjectIdentifier && xseq.getObjectAt(0).equals(PKCSObjectIdentifiers.signedData) ? Certificate.getInstance(new SignedData(ASN1Sequence.getInstance((ASN1TaggedObject)xseq.getObjectAt(1), true)).getCertificates().getObjectAt(0)) : Certificate.getInstance(xseq);
                    } else if (sb.getBagId().equals(PKCSObjectIdentifiers.pkcs8ShroudedKeyBag)) {
                        PrivateKeyInfo privKeyInfo;
                        EncryptedPrivateKeyInfo ePrivKey = EncryptedPrivateKeyInfo.getInstance((ASN1Sequence)sb.getBagValue());
                        MyCipher cipher = PKCS12.getCipher(ePrivKey.getEncryptionAlgorithm().getAlgorithm().getId());
                        if (cipher == null) {
                            return null;
                        }
                        PKCS12PBEParams pbeParams = PKCS12PBEParams.getInstance((ASN1Sequence)ePrivKey.getEncryptionAlgorithm().getParameters());
                        do {
                            dIn = null;
                            try {
                                dIn = new ASN1InputStream(new ByteArrayInputStream(PKCS12.codeData(false, ePrivKey.getEncryptedData(), pbeParams, password, cipher.cipher, cipher.keysize)));
                                privKeyInfo = new PrivateKeyInfo((ASN1Sequence)dIn.readObject());
                                bCorrectPassword = true;
                            }
                            catch (Throwable a_e) {
                                privKeyInfo = null;
                                dIn.close();
                                if (password.length == 0) {
                                    password = new char[]{'\u0000'};
                                    continue;
                                }
                                while ((password = a_passwordReader.readPassword(null).toCharArray()).length == 0 || password.length == 1 && password[0] == '0') {
                                }
                            }
                        } while (!bCorrectPassword);
                        privKey = new AsymmetricCryptoKeyPair(privKeyInfo).getPrivate();
                    }
                    if (alias != null || sb.getBagAttributes() == null) continue;
                    Enumeration e = sb.getBagAttributes().getObjects();
                    while (e.hasMoreElements()) {
                        ASN1Sequence ba = (ASN1Sequence)e.nextElement();
                        ASN1ObjectIdentifier oid = (ASN1ObjectIdentifier)ba.getObjectAt(0);
                        ASN1Encodable att = ((ASN1Set)ba.getObjectAt(1)).getObjectAt(0);
                        if (!oid.equals(PKCSObjectIdentifiers.pkcs_9_at_friendlyName)) continue;
                        alias = ((DERBMPString)att).getString();
                    }
                }
            }
            if (x509cert != null) {
                return new PKCS12(new AsymmetricCryptoKeyPair(privKey), JAPCertificate.getInstance(x509cert));
            }
        }
        catch (Throwable t) {
            // empty catch block
        }
        return null;
    }

    public byte[] toByteArray() {
        return this.toByteArray("".toCharArray());
    }

    public byte[] toByteArray(boolean a_Base64Encoded) {
        if (a_Base64Encoded) {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            try {
                out.write(Base64.createBeginTag(BASE64_TAG).getBytes());
                out.write(Base64.encode(this.toByteArray(), true).getBytes());
                out.write(Base64.createEndTag(BASE64_TAG).getBytes());
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return out.toByteArray();
        }
        return this.toByteArray();
    }

    public byte[] toByteArray(char[] a_password, boolean a_Base64Encoded) {
        if (a_Base64Encoded) {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            try {
                out.write(Base64.createBeginTag(BASE64_TAG).getBytes());
                out.write(Base64.encode(this.toByteArray(a_password), true).getBytes());
                out.write(Base64.createEndTag(BASE64_TAG).getBytes());
            }
            catch (IOException a_e) {
                // empty catch block
            }
            return out.toByteArray();
        }
        return this.toByteArray(a_password);
    }

    public byte[] toByteArray(char[] a_password) {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            this.store(out, a_password);
            out.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return out.toByteArray();
    }

    public void store(OutputStream stream, char[] password) throws IOException {
        ByteArrayOutputStream bOut = new ByteArrayOutputStream();
        if (password == null) {
            password = new char[]{};
        }
        byte[] kSalt = new byte[20];
        this.random.nextBytes(kSalt);
        PKCS12PBEParams kParams = new PKCS12PBEParams(kSalt, 100);
        byte[] kBytes = PKCS12.codeData(true, this.m_keyPair.getPrivate().getEncoded(), kParams, password, new DESedeEngine(), 192);
        AlgorithmIdentifier kAlgId = new AlgorithmIdentifier(new ASN1ObjectIdentifier(KEY_ALGORITHM), kParams.toASN1Primitive());
        EncryptedPrivateKeyInfo kInfo = new EncryptedPrivateKeyInfo(kAlgId, kBytes);
        ASN1Encodable[] seqs = new DERSequence[2];
        ASN1EncodableVector kSeq = new ASN1EncodableVector();
        kSeq.add(PKCSObjectIdentifiers.pkcs_9_at_localKeyId);
        kSeq.add(new DERSet(this.createSubjectKeyId()));
        seqs[0] = new DERSequence(kSeq);
        kSeq = new ASN1EncodableVector();
        kSeq.add(PKCSObjectIdentifiers.pkcs_9_at_friendlyName);
        kSeq.add(new DERSet(new DERBMPString(this.getAlias())));
        seqs[1] = new DERSequence(kSeq);
        DERSet kName = new DERSet(seqs);
        BERConstructedOctetString keyString = new BERConstructedOctetString(new DERSequence(new SafeBag(PKCSObjectIdentifiers.pkcs8ShroudedKeyBag, kInfo.toASN1Primitive(), kName)));
        byte[] cSalt = new byte[20];
        this.random.nextBytes(cSalt);
        PKCS12PBEParams cParams = new PKCS12PBEParams(cSalt, 100);
        AlgorithmIdentifier cAlgId = new AlgorithmIdentifier(new ASN1ObjectIdentifier(CERT_ALGORITHM), cParams);
        CertBag cBag = new CertBag(PKCSObjectIdentifiers.x509certType, new DEROctetString(this.m_x509certificate.getBouncyCastleCertificate()));
        ASN1EncodableVector fSeq = new ASN1EncodableVector();
        fSeq.add(PKCSObjectIdentifiers.pkcs_9_at_localKeyId);
        fSeq.add(new DERSet(this.createSubjectKeyId()));
        seqs = new DERSequence[2];
        seqs[0] = new DERSequence(fSeq);
        fSeq = new ASN1EncodableVector();
        fSeq.add(PKCSObjectIdentifiers.pkcs_9_at_friendlyName);
        fSeq.add(new DERSet(new DERBMPString(this.getAlias())));
        seqs[1] = new DERSequence(fSeq);
        DERSet fName = new DERSet(seqs);
        SafeBag sBag = new SafeBag(PKCSObjectIdentifiers.certBag, cBag.toASN1Primitive(), fName);
        bOut.reset();
        DEROutputStream dOut = new DEROutputStream(bOut);
        dOut.writeObject(new DERSequence(sBag));
        dOut.close();
        byte[] certBytes = PKCS12.codeData(true, bOut.toByteArray(), cParams, password, new RC2Engine(), 40);
        EncryptedData cInfo = new EncryptedData(PKCSObjectIdentifiers.data, cAlgId, new BERConstructedOctetString(certBytes));
        ContentInfo[] c = new ContentInfo[]{new ContentInfo(PKCSObjectIdentifiers.data, keyString), new ContentInfo(PKCSObjectIdentifiers.encryptedData, cInfo)};
        ContentInfo mainInfo = new ContentInfo(PKCSObjectIdentifiers.data, new BERConstructedOctetString(new AuthenticatedSafe(c)));
        byte[] mSalt = new byte[20];
        int itCount = 100;
        this.random.nextBytes(mSalt);
        byte[] contentData = ((ASN1OctetString)mainInfo.getContent()).getOctets();
        MacData mData = null;
        try {
            HMac certMac = new HMac(new SHA1Digest());
            CipherParameters cParam = PKCS12.makePBEMacParameters(password, new PKCS12PBEParams(mSalt, itCount), 160);
            certMac.init(cParam);
            certMac.update(contentData, 0, contentData.length);
            byte[] my_res = new byte[certMac.getMacSize()];
            certMac.doFinal(my_res, 0);
            AlgorithmIdentifier my_algId = new AlgorithmIdentifier(X509ObjectIdentifiers.id_SHA1, null);
            DigestInfo my_dInfo = new DigestInfo(my_algId, my_res);
            mData = new MacData(my_dInfo, mSalt, itCount);
        }
        catch (Exception e) {
            throw new IOException("error constructing MAC: " + e.toString());
        }
        Pfx pfx = new Pfx(mainInfo, mData);
        BEROutputStream berOut = new BEROutputStream(stream);
        berOut.writeObject((Object)pfx);
    }

    public String getAlias() {
        Vector<String> aliases = new Vector<String>();
        X509DistinguishedName subject = this.getSubject();
        aliases.addElement(subject.getCommonName());
        aliases.addElement(subject.getEmailAddress());
        aliases.addElement(subject.getOrganisation());
        for (int i = 0; i < aliases.size(); ++i) {
            if (aliases.elementAt(i) == null || ((String)aliases.elementAt(i)).trim().length() == 0) continue;
            return (String)aliases.elementAt(i);
        }
        return "alias unknown";
    }

    public MyX509Extensions getExtensions() {
        return this.m_x509certificate.getExtensions();
    }

    public X509DistinguishedName getSubject() {
        return this.m_x509certificate.getSubject();
    }

    public X509DistinguishedName getIssuer() {
        return this.m_x509certificate.getIssuer();
    }

    public IMyPrivateKey getPrivateKey() {
        return this.m_keyPair.getPrivate();
    }

    public IMyPublicKey getPublicKey() {
        return this.m_keyPair.getPublic();
    }

    public AsymmetricCryptoKeyPair getKeyPair() {
        return this.m_keyPair;
    }

    public JAPCertificate getX509Certificate() {
        return this.m_x509certificate;
    }

    public PKCS10CertificationRequest createCertifcationRequest() {
        return new PKCS10CertificationRequest(this);
    }

    public boolean setX509Certificate(JAPCertificate a_X509certificate) {
        if (a_X509certificate != null && this.m_x509certificate.getPublicKey().equals(a_X509certificate.getPublicKey())) {
            this.m_x509certificate = (JAPCertificate)a_X509certificate.clone();
            return true;
        }
        return false;
    }

    public void sign(PKCS12 a_pkcs12Certificate) {
        this.m_x509certificate = this.m_x509certificate.sign(a_pkcs12Certificate);
    }

    public void sign(PKCS12 a_signerCertificate, Validity a_validity, MyX509Extensions a_extensions, BigInteger a_serialNumber) {
        this.m_x509certificate = this.m_x509certificate.sign(a_signerCertificate, a_validity, a_extensions, a_serialNumber);
    }

    private static byte[] codeData(boolean encrypt, byte[] data, PKCS12PBEParams pbeParams, char[] password, BlockCipher cipher, int keySize) throws IOException {
        byte[] my_out;
        try {
            PaddedBufferedBlockCipher my_cipher = new PaddedBufferedBlockCipher(new CBCBlockCipher(cipher));
            CipherParameters my_param = PKCS12.makePBEParameters(password, pbeParams, my_cipher.getUnderlyingCipher().getAlgorithmName(), keySize, 64);
            my_param = new ParametersWithRandom(my_param, new SecureRandom());
            ((BufferedBlockCipher)my_cipher).init(encrypt, my_param);
            byte[] my_input = data;
            int my_inputlen = my_input.length;
            int my_len = 0;
            byte[] my_tmp = new byte[((BufferedBlockCipher)my_cipher).getOutputSize(my_inputlen)];
            if (my_inputlen != 0) {
                my_len = ((BufferedBlockCipher)my_cipher).processBytes(my_input, 0, my_inputlen, my_tmp, 0);
            }
            try {
                my_len += ((BufferedBlockCipher)my_cipher).doFinal(my_tmp, my_len);
            }
            catch (Exception e) {
                // empty catch block
            }
            my_out = new byte[my_len];
            System.arraycopy(my_tmp, 0, my_out, 0, my_len);
        }
        catch (Exception e) {
            throw new IOException("exception encrypting data - " + e.toString());
        }
        return my_out;
    }

    private static CipherParameters makePBEMacParameters(char[] password, PKCS12PBEParams pbeParams, int keySize) {
        PBEParametersGenerator generator = PKCS12.makePBEGenerator();
        byte[] key = PBEParametersGenerator.PKCS12PasswordToBytes(password);
        generator.init(key, pbeParams.getIV(), pbeParams.getIterations().intValue());
        CipherParameters param = generator.generateDerivedMacParameters(keySize);
        for (int i = 0; i != key.length; ++i) {
            key[i] = 0;
        }
        return param;
    }

    private static CipherParameters makePBEParameters(char[] password, PKCS12PBEParams pbeParams, String targetAlgorithm, int keySize, int ivSize) {
        PBEParametersGenerator generator = PKCS12.makePBEGenerator();
        byte[] key = PBEParametersGenerator.PKCS12PasswordToBytes(password);
        generator.init(key, pbeParams.getIV(), pbeParams.getIterations().intValue());
        CipherParameters param = ivSize != 0 ? generator.generateDerivedParameters(keySize, ivSize) : generator.generateDerivedParameters(keySize);
        if (targetAlgorithm.startsWith("DES")) {
            KeyParameter kParam;
            if (param instanceof ParametersWithIV) {
                kParam = (KeyParameter)((ParametersWithIV)param).getParameters();
                DESParameters.setOddParity(kParam.getKey());
            } else {
                kParam = (KeyParameter)param;
                DESParameters.setOddParity(kParam.getKey());
            }
        }
        for (int i = 0; i != key.length; ++i) {
            key[i] = 0;
        }
        return param;
    }

    private static PBEParametersGenerator makePBEGenerator() {
        return new PKCS12ParametersGenerator(new SHA1Digest());
    }

    private static MyCipher getCipher(String algId) {
        if (algId.equals(KEY_ALGORITHM)) {
            return new MyCipher(new DESedeEngine(), 192);
        }
        if (algId.equals("1.2.840.113549.1.12.1.4")) {
            return new MyCipher(new DESedeEngine(), 128);
        }
        if (algId.equals("1.2.840.113549.1.12.1.5")) {
            return new MyCipher(new RC2Engine(), 128);
        }
        if (algId.equals(CERT_ALGORITHM)) {
            return new MyCipher(new RC2Engine(), 40);
        }
        return null;
    }

    private SubjectKeyIdentifier createSubjectKeyId() {
        try {
            SubjectPublicKeyInfo keyinfo = this.m_x509certificate.getBouncyCastleSubjectPublicKeyInfo();
            byte[] digest = X509SubjectKeyIdentifier.getDigest(keyinfo);
            return new SubjectKeyIdentifier(digest);
        }
        catch (Exception e) {
            throw new RuntimeException("error creating key");
        }
    }

    private static class MyCipher {
        public BlockCipher cipher;
        public int keysize;

        MyCipher(BlockCipher c, int ks) {
            this.cipher = c;
            this.keysize = ks;
        }
    }
}

