/*
 * Decompiled with CFR 0.152.
 */
package mixconfig.tools.dataretention;

import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import mixconfig.tools.dataretention.DataRetentionLogFileEntry;
import mixconfig.tools.dataretention.DataRetentionLogFileHeader;

public class DataRetentionLogFile {
    private File m_File;
    private DataRetentionLogFileHeader m_Header;
    private byte[] m_SymKey;
    private byte[] m_Footer;
    private FileInputStream m_LogFileInputStream;
    private int m_currentLogVerifyLine;
    private static final int FOOTER_SIZE = 20;

    public DataRetentionLogFile(File logFile) throws IOException {
        this.m_File = logFile;
        this.parseHeader();
        this.readFooter();
    }

    private void readFooter() throws IOException {
        long fileSize = this.m_File.length();
        FileInputStream fin = new FileInputStream(this.m_File);
        fin.skip(fileSize - 20L);
        this.m_Footer = new byte[20];
        fin.read(this.m_Footer);
        fin.close();
    }

    private void parseHeader() throws IOException {
        this.m_Header = new DataRetentionLogFileHeader();
        this.m_Header.parseFromFile(new FileInputStream(this.m_File));
    }

    public DataRetentionLogFileHeader getHeader() {
        return this.m_Header;
    }

    public int getEncryptedKeyCount() {
        return this.m_Header.getEncryptedKeyCount();
    }

    public byte[] getEncryptedKey(int index) {
        return this.m_Header.getEncryptedKey(index);
    }

    public void setDecryptionKey(byte[] symkey) {
        this.m_SymKey = symkey;
    }

    public void verifyHeader() throws Exception {
        this.m_Header.verifyHeader(this.m_SymKey);
    }

    public void verifyFooter() throws Exception {
        int footerNr;
        byte[] iv = new byte[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1};
        byte[] buff = new byte[1024];
        int decSize = DataRetentionLogFileHeader.decryptAndVerify(this.m_Footer, iv, this.m_SymKey, buff);
        if (decSize != 4) {
            throw new IOException("Wrong byte size of decrypted log entries number");
        }
        int expNr = this.getExpectedNrOfLogEntries();
        if (expNr != (footerNr = buff[0] << 24 | buff[1] << 16 & 0xFFFFFF | buff[2] << 8 & 0xFFFF | buff[3] & 0xFF)) {
            throw new IOException("Nr of Log Entries reported by footer does not much expected number of log entries (based on file size)");
        }
    }

    public int getNrOfLogLines() {
        long fileSize = this.m_File.length();
        long logSize = fileSize - 20L - (long)this.m_Header.getLength();
        return (int)((logSize + (long)this.m_Header.getSizeOfLogLine() - 1L) / (long)this.m_Header.getSizeOfLogLine());
    }

    public void verifyFirstLogLine() throws Exception {
        this.m_LogFileInputStream = new FileInputStream(this.m_File);
        this.m_LogFileInputStream.skip(this.m_Header.getLength());
        this.m_currentLogVerifyLine = 0;
        this.verifyNextLogLine();
    }

    public void verifyNextLogLine() throws Exception {
        byte[] buff = new byte[this.m_Header.getSizeOfLogLine()];
        int ret = this.m_LogFileInputStream.read(buff);
        ++this.m_currentLogVerifyLine;
        if (ret == -1 || this.m_currentLogVerifyLine > this.getNrOfLogLines()) {
            this.m_LogFileInputStream.close();
            throw new EOFException();
        }
        if (this.m_currentLogVerifyLine == this.getNrOfLogLines() && this.getExpectedNrOfLogEntries() % this.m_Header.getNrOfLogEntriesPerLogLine() != 0) {
            ret = this.getExpectedNrOfLogEntries() % this.m_Header.getNrOfLogEntriesPerLogLine() * this.m_Header.getSizeOfLogEntry() + 16;
        }
        DataRetentionLogFileHeader.decryptAndVerify(buff, 0, ret, this.createIV(this.m_currentLogVerifyLine - 1), this.m_SymKey, null);
    }

    public DataRetentionLogFileEntry[] search(long t_out, int d_t) throws Exception {
        int maxInd;
        int lowInd = 0;
        int upInd = maxInd = this.getExpectedNrOfLogEntries() - 1;
        int midInd = lowInd + (upInd - lowInd) / 2;
        long l = this.getToutOfLogEntry(lowInd);
        long u = this.getToutOfLogEntry(upInd);
        long m = this.getToutOfLogEntry(midInd);
        long t_min = t_out - (long)d_t;
        long t_max = t_out + (long)d_t;
        if (u < t_min || t_max < l) {
            return null;
        }
        while (true) {
            if (t_out < m) {
                upInd = midInd - 1;
            } else {
                if (t_out <= m) break;
                lowInd = midInd + 1;
            }
            if (upInd <= lowInd) break;
            midInd = lowInd + (upInd - lowInd) / 2;
            m = this.getToutOfLogEntry(midInd);
        }
        for (lowInd = midInd; t_min <= (l = this.getToutOfLogEntry(lowInd)) && l <= t_max && lowInd > 0; --lowInd) {
        }
        for (upInd = midInd; t_min <= (u = this.getToutOfLogEntry(upInd)) && u <= t_max && upInd < maxInd; ++upInd) {
        }
        return this.getAllLogEntries(lowInd + 1, upInd - 1);
    }

    private DataRetentionLogFileEntry[] getAllLogEntries(int lowInd, int upInd) throws Exception {
        int l = lowInd / this.m_Header.getNrOfLogEntriesPerLogLine();
        byte[] logLine = this.readAndDecrpytLogLine(l);
        int off = lowInd % this.m_Header.getNrOfLogEntriesPerLogLine() * this.m_Header.getSizeOfLogEntry();
        DataRetentionLogFileEntry[] entries = new DataRetentionLogFileEntry[upInd - lowInd + 1];
        int i = 0;
        while (true) {
            entries[i++] = new DataRetentionLogFileEntry(logLine, off, this.m_Header);
            if (++lowInd > upInd) break;
            if (lowInd % this.m_Header.getNrOfLogEntriesPerLogLine() == 0) {
                logLine = this.readAndDecrpytLogLine(++l);
                off = 0;
                continue;
            }
            off += this.m_Header.getSizeOfLogEntry();
        }
        return entries;
    }

    byte[] readAndDecrpytLogLine(int lineNr) throws Exception {
        FileInputStream fin = new FileInputStream(this.m_File);
        fin.skip(this.m_Header.getLength());
        if (lineNr > 0) {
            fin.skip(lineNr * this.m_Header.getSizeOfLogLine());
        }
        int size = this.m_Header.getSizeOfLogLine();
        if (lineNr == this.getNrOfLogLines() - 1 && this.getExpectedNrOfLogEntries() % this.m_Header.getNrOfLogEntriesPerLogLine() != 0) {
            size = this.getExpectedNrOfLogEntries() % this.m_Header.getNrOfLogEntriesPerLogLine() * this.m_Header.getSizeOfLogEntry() + 16;
        }
        byte[] buff = new byte[size];
        byte[] plain = new byte[size - 16];
        fin.read(buff);
        DataRetentionLogFileHeader.decryptAndVerify(buff, 0, size, this.createIV(lineNr), this.m_SymKey, plain);
        fin.close();
        return plain;
    }

    private long getToutOfLogEntry(int ind) throws Exception {
        byte[] logLine = this.readAndDecrpytLogLine(ind / this.m_Header.getNrOfLogEntriesPerLogLine());
        int i = ind % this.m_Header.getNrOfLogEntriesPerLogLine() * this.m_Header.getSizeOfLogEntry() + 4;
        long t = (long)(logLine[i] << 24) & 0xFF000000L | (long)(logLine[i + 1] << 16) & 0xFF0000L | (long)(logLine[i + 2] << 8) & 0xFF00L | (long)logLine[i + 3] & 0xFFL;
        return t;
    }

    private byte[] createIV(int blocksCounter) {
        byte[] iv = new byte[12];
        for (int i = 0; i < 8; ++i) {
            iv[i] = 0;
        }
        iv[8] = (byte)(blocksCounter >> 24 & 0xFF);
        iv[9] = (byte)(blocksCounter >> 16 & 0xFF);
        iv[10] = (byte)(blocksCounter >> 8 & 0xFF);
        iv[11] = (byte)(blocksCounter & 0xFF);
        return iv;
    }

    private int getExpectedNrOfLogEntries() {
        long fileSize = this.m_File.length();
        long logSize = fileSize - 20L - (long)this.m_Header.getLength();
        int entries = (int)(logSize / (long)this.m_Header.getSizeOfLogLine()) * this.m_Header.getNrOfLogEntriesPerLogLine();
        if (logSize % (long)this.m_Header.getSizeOfLogLine() > 0L) {
            entries = (int)((long)entries + (logSize % (long)this.m_Header.getSizeOfLogLine() - 16L) / (long)this.m_Header.getSizeOfLogEntry());
        }
        return entries;
    }
}

