/*
 * Decompiled with CFR 0.152.
 */
package anon.client;

import anon.client.TrustException;
import anon.client.TrustModel;
import anon.infoservice.AbstractMixCascadeContainer;
import anon.infoservice.Database;
import anon.infoservice.MixCascade;
import anon.pay.PayAccountsFile;
import java.security.SignatureException;
import java.util.Hashtable;
import java.util.Random;
import java.util.Vector;

public abstract class AbstractAutoSwitchedMixCascadeContainer
extends AbstractMixCascadeContainer {
    private Hashtable m_alreadyTriedCascades;
    private Random m_random;
    private MixCascade m_initialCascade;
    private MixCascade m_currentCascade;
    private boolean m_bKeepCurrentCascade;
    private boolean m_bSkipInitialCascade;
    static /* synthetic */ Class class$anon$infoservice$MixCascade;

    public AbstractAutoSwitchedMixCascadeContainer(boolean bl, MixCascade mixCascade) {
        this.m_bSkipInitialCascade = bl;
        this.m_alreadyTriedCascades = new Hashtable();
        this.m_random = new Random(System.currentTimeMillis());
        this.m_random.nextInt();
        this.m_initialCascade = mixCascade;
        this.m_bKeepCurrentCascade = false;
    }

    public final MixCascade getInitialCascade() {
        return this.m_initialCascade;
    }

    public final MixCascade getNextRandomCascade() {
        return this.getNextCascade(true);
    }

    public final MixCascade getNextCascade() {
        return this.getNextCascade(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final MixCascade getNextCascade(boolean bl) {
        Hashtable hashtable = this.m_alreadyTriedCascades;
        synchronized (hashtable) {
            if (!this.isServiceAutoSwitched() && !bl) {
                this.m_alreadyTriedCascades.clear();
                this.m_bKeepCurrentCascade = false;
                if (this.m_currentCascade == null) {
                    this.m_currentCascade = this.m_initialCascade;
                }
            } else if (this.m_bKeepCurrentCascade) {
                this.m_bKeepCurrentCascade = false;
                if (this.m_currentCascade == null) {
                    this.m_currentCascade = this.m_initialCascade;
                }
                if (this.m_currentCascade != null) {
                    this.m_alreadyTriedCascades.put(this.m_currentCascade.getId(), this.m_currentCascade);
                }
            } else if (this.m_bSkipInitialCascade || this.m_initialCascade == null || this.m_alreadyTriedCascades.containsKey(this.m_initialCascade.getId())) {
                MixCascade mixCascade = null;
                boolean bl2 = true;
                Vector vector = Database.getInstance(class$anon$infoservice$MixCascade == null ? (class$anon$infoservice$MixCascade = AbstractAutoSwitchedMixCascadeContainer.class$("anon.infoservice.MixCascade")) : class$anon$infoservice$MixCascade).getEntryList();
                if (vector.size() > 0) {
                    int n;
                    int n2 = this.m_random.nextInt();
                    if (n2 < 0) {
                        n2 *= -1;
                        bl2 = false;
                    }
                    n2 %= vector.size();
                    for (n = 0; n < vector.size(); ++n) {
                        mixCascade = (MixCascade)vector.elementAt(n2);
                        if (!this.m_alreadyTriedCascades.containsKey(mixCascade.getId())) {
                            this.m_alreadyTriedCascades.put(mixCascade.getId(), mixCascade);
                            if (this.isSuitableCascade(mixCascade)) break;
                        }
                        if (bl2) {
                            n2 = (n2 + 1) % vector.size();
                            continue;
                        }
                        if (--n2 >= 0) continue;
                        n2 = vector.size() - 1;
                    }
                    if (n == vector.size()) {
                        if (this.m_alreadyTriedCascades.size() == 0) {
                            // empty if block
                        }
                        mixCascade = null;
                    }
                } else if (this.m_initialCascade == null) {
                    return null;
                }
                if (mixCascade == null) {
                    this.m_bSkipInitialCascade = false;
                    this.m_alreadyTriedCascades.clear();
                    mixCascade = this.getNextCascade();
                    if (mixCascade == null && this.m_initialCascade != null) {
                        mixCascade = this.m_initialCascade;
                        this.m_alreadyTriedCascades.put(this.m_initialCascade.getId(), this.m_initialCascade);
                    }
                }
                this.m_currentCascade = mixCascade;
            } else {
                this.m_alreadyTriedCascades.put(this.m_initialCascade.getId(), this.m_initialCascade);
                this.m_currentCascade = this.m_initialCascade;
            }
            if (this.m_bSkipInitialCascade) {
                this.m_initialCascade = this.m_currentCascade;
            }
            this.m_bSkipInitialCascade = false;
        }
        return this.m_currentCascade;
    }

    public abstract boolean isServiceAutoSwitched();

    public abstract boolean isReconnectedAutomatically();

    public abstract boolean isPaidServiceAllowed();

    private final boolean isSuitableCascade(MixCascade mixCascade) {
        if (mixCascade == null) {
            return false;
        }
        if (mixCascade.isPayment() && !TrustModel.getCurrentTrustModel().isPaymentForced() && PayAccountsFile.getInstance().getChargedAccount(mixCascade.getPIID()) == null && (TrustModel.getCurrentTrustModel().isEditable() || !this.isPaidServiceAllowed())) {
            return false;
        }
        if (this.m_initialCascade != null && this.m_bSkipInitialCascade && mixCascade.equals(this.m_initialCascade)) {
            return false;
        }
        return this.isTrusted(mixCascade);
    }

    public final MixCascade getCurrentCascade() {
        return this.m_currentCascade;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean setCurrentCascade(MixCascade mixCascade) {
        if (!this.isTrusted(mixCascade)) {
            return false;
        }
        Hashtable hashtable = this.m_alreadyTriedCascades;
        synchronized (hashtable) {
            this.m_bKeepCurrentCascade = true;
            this.m_currentCascade = mixCascade;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void keepCurrentService(boolean bl) {
        Hashtable hashtable = this.m_alreadyTriedCascades;
        synchronized (hashtable) {
            this.m_bKeepCurrentCascade = bl;
        }
    }

    public final void checkTrust(MixCascade mixCascade) throws TrustException, SignatureException {
        TrustModel.getCurrentTrustModel().checkTrust(mixCascade);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

