/*
 * Decompiled with CFR 0.152.
 */
package javax.swing;

import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.FocusListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Locale;
import java.util.Vector;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleAction;
import javax.accessibility.AccessibleComponent;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import javax.accessibility.AccessibleSelection;
import javax.accessibility.AccessibleState;
import javax.accessibility.AccessibleStateSet;
import javax.accessibility.AccessibleText;
import javax.accessibility.AccessibleValue;
import javax.swing.AbstractListModel;
import javax.swing.DefaultListSelectionModel;
import javax.swing.JComponent;
import javax.swing.JViewport;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.ListSelectionModel;
import javax.swing.Scrollable;
import javax.swing.UIManager;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.plaf.ListUI;

public class JList
extends JComponent
implements Scrollable,
Accessible {
    private static final String uiClassID = "ListUI";
    private int fixedCellWidth = -1;
    private int fixedCellHeight = -1;
    private int horizontalScrollIncrement = -1;
    private Object prototypeCellValue;
    private int visibleRowCount = 8;
    private Color selectionForeground;
    private Color selectionBackground;
    private ListSelectionModel selectionModel;
    private ListModel dataModel;
    private ListCellRenderer cellRenderer;
    private ListSelectionListener selectionListener;
    static /* synthetic */ Class class$javax$swing$event$ListSelectionListener;

    public JList() {
        this(new AbstractListModel(){

            public Object getElementAt(int n) {
                return "No Data Model";
            }

            public int getSize() {
                return 0;
            }
        });
    }

    public JList(final Vector vector) {
        this(new AbstractListModel(){

            public Object getElementAt(int n) {
                return vector.elementAt(n);
            }

            public int getSize() {
                return vector.size();
            }
        });
    }

    public JList(ListModel listModel) {
        if (listModel == null) {
            throw new IllegalArgumentException("dataModel must be non null");
        }
        this.dataModel = listModel;
        this.selectionModel = this.createSelectionModel();
        this.setAutoscrolls(true);
        this.setOpaque(true);
        this.updateUI();
    }

    public JList(final Object[] objectArray) {
        this(new AbstractListModel(){

            public Object getElementAt(int n) {
                return objectArray[n];
            }

            public int getSize() {
                return objectArray.length;
            }
        });
    }

    public void addListSelectionListener(ListSelectionListener listSelectionListener) {
        if (this.selectionListener == null) {
            this.selectionListener = new ListSelectionHandler();
            this.getSelectionModel().addListSelectionListener(this.selectionListener);
        }
        this.listenerList.add(class$javax$swing$event$ListSelectionListener != null ? class$javax$swing$event$ListSelectionListener : (class$javax$swing$event$ListSelectionListener = JList.class$("javax.swing.event.ListSelectionListener")), listSelectionListener);
    }

    public void addSelectionInterval(int n, int n2) {
        this.getSelectionModel().addSelectionInterval(n, n2);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public void clearSelection() {
        this.getSelectionModel().clearSelection();
    }

    protected ListSelectionModel createSelectionModel() {
        return new DefaultListSelectionModel();
    }

    public void ensureIndexIsVisible(int n) {
        Rectangle rectangle = this.getCellBounds(n, n);
        if (rectangle != null) {
            this.scrollRectToVisible(rectangle);
        }
    }

    protected void fireSelectionValueChanged(int n, int n2, boolean bl) {
        Object[] objectArray = this.listenerList.getListenerList();
        ListSelectionEvent listSelectionEvent = null;
        int n3 = objectArray.length - 2;
        while (n3 >= 0) {
            if (objectArray[n3] == (class$javax$swing$event$ListSelectionListener != null ? class$javax$swing$event$ListSelectionListener : JList.class$("javax.swing.event.ListSelectionListener"))) {
                if (listSelectionEvent == null) {
                    listSelectionEvent = new ListSelectionEvent(this, n, n2, bl);
                }
                ((ListSelectionListener)objectArray[n3 + 1]).valueChanged(listSelectionEvent);
            }
            n3 -= 2;
        }
    }

    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new AccessibleJList();
        }
        return this.accessibleContext;
    }

    public int getAnchorSelectionIndex() {
        return this.getSelectionModel().getAnchorSelectionIndex();
    }

    public Rectangle getCellBounds(int n, int n2) {
        ListUI listUI = this.getUI();
        return listUI != null ? listUI.getCellBounds(this, n, n2) : null;
    }

    public ListCellRenderer getCellRenderer() {
        return this.cellRenderer;
    }

    public int getFirstVisibleIndex() {
        Point point = this.getVisibleRect().getLocation();
        return this.locationToIndex(point);
    }

    public int getFixedCellHeight() {
        return this.fixedCellHeight;
    }

    public int getFixedCellWidth() {
        return this.fixedCellWidth;
    }

    public int getLastVisibleIndex() {
        Rectangle rectangle = this.getVisibleRect();
        Point point = new Point(rectangle.x + rectangle.width - 1, rectangle.y + rectangle.height - 1);
        return this.locationToIndex(point);
    }

    public int getLeadSelectionIndex() {
        return this.getSelectionModel().getLeadSelectionIndex();
    }

    public int getMaxSelectionIndex() {
        return this.getSelectionModel().getMaxSelectionIndex();
    }

    public int getMinSelectionIndex() {
        return this.getSelectionModel().getMinSelectionIndex();
    }

    public ListModel getModel() {
        return this.dataModel;
    }

    public Dimension getPreferredScrollableViewportSize() {
        Insets insets = this.getInsets();
        int n = insets.left + insets.right;
        int n2 = insets.top + insets.bottom;
        int n3 = this.getVisibleRowCount();
        int n4 = this.getFixedCellWidth();
        int n5 = this.getFixedCellHeight();
        if (n4 > 0 && n5 > 0) {
            int n6 = n4 + n;
            int n7 = n3 * n5 + n2;
            return new Dimension(n6, n7);
        }
        if (this.getModel().getSize() > 0) {
            int n8 = this.getPreferredSize().width;
            Rectangle rectangle = this.getCellBounds(0, 0);
            int n9 = n3 * rectangle.height + n2;
            return new Dimension(n8, n9);
        }
        n4 = n4 > 0 ? n4 : 256;
        n5 = n5 > 0 ? n5 : 16;
        return new Dimension(n4, n5 * n3);
    }

    public Object getPrototypeCellValue() {
        return this.prototypeCellValue;
    }

    public int getScrollableBlockIncrement(Rectangle rectangle, int n, int n2) {
        return n == 1 ? rectangle.height : rectangle.width;
    }

    public boolean getScrollableTracksViewportHeight() {
        if (this.getParent() instanceof JViewport) {
            return ((JViewport)this.getParent()).getHeight() > this.getPreferredSize().height;
        }
        return false;
    }

    public boolean getScrollableTracksViewportWidth() {
        if (this.getParent() instanceof JViewport) {
            return ((JViewport)this.getParent()).getWidth() > this.getPreferredSize().width;
        }
        return false;
    }

    public int getScrollableUnitIncrement(Rectangle rectangle, int n, int n2) {
        if (n == 0) {
            Font font = this.getFont();
            return font != null ? font.getSize() : 1;
        }
        int n3 = this.getFirstVisibleIndex();
        if (n3 == -1) {
            return 0;
        }
        if (n2 > 0) {
            Rectangle rectangle2 = this.getCellBounds(n3, n3);
            return rectangle2 == null ? 0 : rectangle2.height - (rectangle.y - rectangle2.y);
        }
        Rectangle rectangle3 = this.getCellBounds(n3, n3);
        if (rectangle3.y == rectangle.y && n3 == 0) {
            return 0;
        }
        if (rectangle3.y == rectangle.y) {
            Rectangle rectangle4 = this.getCellBounds(n3 - 1, n3 - 1);
            return rectangle4 == null ? 0 : rectangle4.height;
        }
        return rectangle.y - rectangle3.y;
    }

    public int getSelectedIndex() {
        return this.getMinSelectionIndex();
    }

    public int[] getSelectedIndices() {
        ListSelectionModel listSelectionModel = this.getSelectionModel();
        int n = listSelectionModel.getMinSelectionIndex();
        int n2 = listSelectionModel.getMaxSelectionIndex();
        if (n < 0 || n2 < 0) {
            return new int[0];
        }
        int[] nArray = new int[1 + (n2 - n)];
        int n3 = 0;
        int n4 = n;
        while (n4 <= n2) {
            if (listSelectionModel.isSelectedIndex(n4)) {
                nArray[n3++] = n4;
            }
            ++n4;
        }
        int[] nArray2 = new int[n3];
        System.arraycopy(nArray, 0, nArray2, 0, n3);
        return nArray2;
    }

    public Object getSelectedValue() {
        int n = this.getMinSelectionIndex();
        return n == -1 ? null : this.getModel().getElementAt(n);
    }

    public Object[] getSelectedValues() {
        ListSelectionModel listSelectionModel = this.getSelectionModel();
        ListModel listModel = this.getModel();
        int n = listSelectionModel.getMinSelectionIndex();
        int n2 = listSelectionModel.getMaxSelectionIndex();
        if (n < 0 || n2 < 0) {
            return new Object[0];
        }
        Object[] objectArray = new Object[1 + (n2 - n)];
        int n3 = 0;
        int n4 = n;
        while (n4 <= n2) {
            if (listSelectionModel.isSelectedIndex(n4)) {
                objectArray[n3++] = listModel.getElementAt(n4);
            }
            ++n4;
        }
        Object[] objectArray2 = new Object[n3];
        System.arraycopy(objectArray, 0, objectArray2, 0, n3);
        return objectArray2;
    }

    public Color getSelectionBackground() {
        return this.selectionBackground;
    }

    public Color getSelectionForeground() {
        return this.selectionForeground;
    }

    public int getSelectionMode() {
        return this.getSelectionModel().getSelectionMode();
    }

    public ListSelectionModel getSelectionModel() {
        return this.selectionModel;
    }

    public ListUI getUI() {
        return (ListUI)this.ui;
    }

    public String getUIClassID() {
        return uiClassID;
    }

    public boolean getValueIsAdjusting() {
        return this.getSelectionModel().getValueIsAdjusting();
    }

    public int getVisibleRowCount() {
        return this.visibleRowCount;
    }

    public Point indexToLocation(int n) {
        ListUI listUI = this.getUI();
        return listUI != null ? listUI.indexToLocation(this, n) : null;
    }

    public boolean isSelectedIndex(int n) {
        return this.getSelectionModel().isSelectedIndex(n);
    }

    public boolean isSelectionEmpty() {
        return this.getSelectionModel().isSelectionEmpty();
    }

    public int locationToIndex(Point point) {
        ListUI listUI = this.getUI();
        return listUI != null ? listUI.locationToIndex(this, point) : -1;
    }

    protected String paramString() {
        String string = this.selectionForeground != null ? this.selectionForeground.toString() : "";
        String string2 = this.selectionBackground != null ? this.selectionBackground.toString() : "";
        return String.valueOf(super.paramString()) + ",fixedCellHeight=" + this.fixedCellHeight + ",fixedCellWidth=" + this.fixedCellWidth + ",horizontalScrollIncrement=" + this.horizontalScrollIncrement + ",selectionBackground=" + string2 + ",selectionForeground=" + string + ",visibleRowCount=" + this.visibleRowCount;
    }

    public void removeListSelectionListener(ListSelectionListener listSelectionListener) {
        this.listenerList.remove(class$javax$swing$event$ListSelectionListener != null ? class$javax$swing$event$ListSelectionListener : (class$javax$swing$event$ListSelectionListener = JList.class$("javax.swing.event.ListSelectionListener")), listSelectionListener);
    }

    public void removeSelectionInterval(int n, int n2) {
        this.getSelectionModel().removeSelectionInterval(n, n2);
    }

    public void setCellRenderer(ListCellRenderer listCellRenderer) {
        ListCellRenderer listCellRenderer2 = this.cellRenderer;
        this.cellRenderer = listCellRenderer;
        if (listCellRenderer != null && !listCellRenderer.equals(listCellRenderer2)) {
            this.updateFixedCellSize();
        }
        this.firePropertyChange("cellRenderer", listCellRenderer2, listCellRenderer);
    }

    public void setFixedCellHeight(int n) {
        int n2 = this.fixedCellHeight;
        this.fixedCellHeight = n;
        this.firePropertyChange("fixedCellHeight", n2, this.fixedCellHeight);
    }

    public void setFixedCellWidth(int n) {
        int n2 = this.fixedCellWidth;
        this.fixedCellWidth = n;
        this.firePropertyChange("fixedCellWidth", n2, this.fixedCellWidth);
    }

    public void setListData(final Vector vector) {
        this.setModel(new AbstractListModel(){

            public Object getElementAt(int n) {
                return vector.elementAt(n);
            }

            public int getSize() {
                return vector.size();
            }
        });
    }

    public void setListData(final Object[] objectArray) {
        this.setModel(new AbstractListModel(){

            public Object getElementAt(int n) {
                return objectArray[n];
            }

            public int getSize() {
                return objectArray.length;
            }
        });
    }

    public void setModel(ListModel listModel) {
        if (listModel == null) {
            throw new IllegalArgumentException("model must be non null");
        }
        ListModel listModel2 = this.dataModel;
        this.dataModel = listModel;
        this.firePropertyChange("model", listModel2, this.dataModel);
        this.clearSelection();
    }

    public void setPrototypeCellValue(Object object) {
        Object object2 = this.prototypeCellValue;
        this.prototypeCellValue = object;
        if (object != null && !object.equals(object2)) {
            this.updateFixedCellSize();
        }
        this.firePropertyChange("prototypeCellValue", object2, object);
    }

    public void setSelectedIndex(int n) {
        this.getSelectionModel().setSelectionInterval(n, n);
    }

    public void setSelectedIndices(int[] nArray) {
        ListSelectionModel listSelectionModel = this.getSelectionModel();
        listSelectionModel.clearSelection();
        int n = 0;
        while (n < nArray.length) {
            listSelectionModel.addSelectionInterval(nArray[n], nArray[n]);
            ++n;
        }
    }

    public void setSelectedValue(Object object, boolean bl) {
        if (object == null) {
            this.setSelectedIndex(-1);
        } else if (!object.equals(this.getSelectedValue())) {
            ListModel listModel = this.getModel();
            int n = 0;
            int n2 = listModel.getSize();
            while (n < n2) {
                if (object.equals(listModel.getElementAt(n))) {
                    this.setSelectedIndex(n);
                    if (bl) {
                        this.ensureIndexIsVisible(n);
                    }
                    this.repaint();
                    return;
                }
                ++n;
            }
            this.setSelectedIndex(-1);
        }
        this.repaint();
    }

    public void setSelectionBackground(Color color) {
        Color color2 = this.selectionBackground;
        this.selectionBackground = color;
        this.firePropertyChange("selectionBackground", color2, color);
    }

    public void setSelectionForeground(Color color) {
        Color color2 = this.selectionForeground;
        this.selectionForeground = color;
        this.firePropertyChange("selectionForeground", color2, color);
    }

    public void setSelectionInterval(int n, int n2) {
        this.getSelectionModel().setSelectionInterval(n, n2);
    }

    public void setSelectionMode(int n) {
        this.getSelectionModel().setSelectionMode(n);
    }

    public void setSelectionModel(ListSelectionModel listSelectionModel) {
        if (listSelectionModel == null) {
            throw new IllegalArgumentException("selectionModel must be non null");
        }
        if (this.selectionListener != null) {
            this.selectionModel.removeListSelectionListener(this.selectionListener);
            listSelectionModel.addListSelectionListener(this.selectionListener);
        }
        ListSelectionModel listSelectionModel2 = this.selectionModel;
        this.selectionModel = listSelectionModel;
        this.firePropertyChange("selectionModel", listSelectionModel2, listSelectionModel);
    }

    public void setUI(ListUI listUI) {
        super.setUI(listUI);
    }

    public void setValueIsAdjusting(boolean bl) {
        this.getSelectionModel().setValueIsAdjusting(bl);
    }

    public void setVisibleRowCount(int n) {
        int n2 = this.visibleRowCount;
        this.visibleRowCount = Math.max(0, n);
        this.firePropertyChange("visibleRowCount", n2, n);
    }

    private void updateFixedCellSize() {
        ListCellRenderer listCellRenderer = this.getCellRenderer();
        Object object = this.getPrototypeCellValue();
        if (listCellRenderer != null && object != null) {
            Component component = listCellRenderer.getListCellRendererComponent(this, object, 0, false, false);
            Font font = component.getFont();
            component.setFont(this.getFont());
            Dimension dimension = component.getPreferredSize();
            this.fixedCellWidth = dimension.width;
            this.fixedCellHeight = dimension.height;
            component.setFont(font);
        }
    }

    public void updateUI() {
        this.setUI((ListUI)UIManager.getUI(this));
        this.invalidate();
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        if (this.ui != null && this.getUIClassID().equals(uiClassID)) {
            this.ui.installUI(this);
        }
    }

    private class ListSelectionHandler
    implements ListSelectionListener,
    Serializable {
        ListSelectionHandler() {
        }

        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            JList.this.fireSelectionValueChanged(listSelectionEvent.getFirstIndex(), listSelectionEvent.getLastIndex(), listSelectionEvent.getValueIsAdjusting());
        }
    }

    protected class AccessibleJList
    extends JComponent.AccessibleJComponent
    implements AccessibleSelection,
    PropertyChangeListener,
    ListSelectionListener,
    ListDataListener {
        int leadSelectionIndex;

        public AccessibleJList() {
            super(JList.this);
            JList.this.addPropertyChangeListener(this);
            JList.this.getSelectionModel().addListSelectionListener(this);
            JList.this.getModel().addListDataListener(this);
            this.leadSelectionIndex = JList.this.getLeadSelectionIndex();
        }

        public void addAccessibleSelection(int n) {
            JList.this.addSelectionInterval(n, n);
        }

        public void clearAccessibleSelection() {
            JList.this.clearSelection();
        }

        public void contentsChanged(ListDataEvent listDataEvent) {
            this.firePropertyChange("AccessibleVisibleData", new Boolean(false), new Boolean(true));
        }

        public Accessible getAccessibleAt(Point point) {
            int n = JList.this.locationToIndex(point);
            if (n >= 0) {
                return new AccessibleJListChild(JList.this, n);
            }
            return null;
        }

        public Accessible getAccessibleChild(int n) {
            if (n >= JList.this.getModel().getSize()) {
                return null;
            }
            return new AccessibleJListChild(JList.this, n);
        }

        public int getAccessibleChildrenCount() {
            return JList.this.getModel().getSize();
        }

        public AccessibleRole getAccessibleRole() {
            return AccessibleRole.LIST;
        }

        public AccessibleSelection getAccessibleSelection() {
            return this;
        }

        public Accessible getAccessibleSelection(int n) {
            int n2 = this.getAccessibleSelectionCount();
            if (n < 0 || n >= n2) {
                return null;
            }
            return this.getAccessibleChild(JList.this.getSelectedIndices()[n]);
        }

        public int getAccessibleSelectionCount() {
            return JList.this.getSelectedIndices().length;
        }

        public AccessibleStateSet getAccessibleStateSet() {
            AccessibleStateSet accessibleStateSet = super.getAccessibleStateSet();
            if (JList.this.selectionModel.getSelectionMode() != 0) {
                accessibleStateSet.add(AccessibleState.MULTISELECTABLE);
            }
            return accessibleStateSet;
        }

        public void intervalAdded(ListDataEvent listDataEvent) {
            this.firePropertyChange("AccessibleVisibleData", new Boolean(false), new Boolean(true));
        }

        public void intervalRemoved(ListDataEvent listDataEvent) {
            this.firePropertyChange("AccessibleVisibleData", new Boolean(false), new Boolean(true));
        }

        public boolean isAccessibleChildSelected(int n) {
            return JList.this.isSelectedIndex(n);
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            String string = propertyChangeEvent.getPropertyName();
            Object object = propertyChangeEvent.getOldValue();
            Object object2 = propertyChangeEvent.getNewValue();
            if (string.compareTo("model") == 0) {
                if (object != null && object instanceof ListModel) {
                    ((ListModel)object).removeListDataListener(this);
                }
                if (object2 != null && object2 instanceof ListModel) {
                    ((ListModel)object2).addListDataListener(this);
                }
            } else if (string.compareTo("selectionModel") == 0) {
                if (object != null && object instanceof ListSelectionModel) {
                    ((ListSelectionModel)object).removeListSelectionListener(this);
                }
                if (object2 != null && object2 instanceof ListSelectionModel) {
                    ((ListSelectionModel)object2).addListSelectionListener(this);
                }
                this.firePropertyChange("AccessibleSelection", new Boolean(false), new Boolean(true));
            }
        }

        public void removeAccessibleSelection(int n) {
            JList.this.removeSelectionInterval(n, n);
        }

        public void selectAllAccessibleSelection() {
            JList.this.addSelectionInterval(0, this.getAccessibleChildrenCount() - 1);
        }

        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            Object object;
            Object object2;
            int n = this.leadSelectionIndex;
            this.leadSelectionIndex = JList.this.getLeadSelectionIndex();
            if (n != this.leadSelectionIndex) {
                object2 = n >= 0 ? this.getAccessibleChild(n) : null;
                object = this.leadSelectionIndex >= 0 ? this.getAccessibleChild(this.leadSelectionIndex) : null;
                this.firePropertyChange("AccessibleActiveDescendant", object2, object);
            }
            this.firePropertyChange("AccessibleVisibleData", new Boolean(false), new Boolean(true));
            this.firePropertyChange("AccessibleSelection", new Boolean(false), new Boolean(true));
            object2 = this.getAccessibleStateSet();
            object = JList.this.getSelectionModel();
            if (object.getSelectionMode() != 0) {
                if (!((AccessibleStateSet)object2).contains(AccessibleState.MULTISELECTABLE)) {
                    ((AccessibleStateSet)object2).add(AccessibleState.MULTISELECTABLE);
                    this.firePropertyChange("AccessibleState", null, AccessibleState.MULTISELECTABLE);
                }
            } else if (((AccessibleStateSet)object2).contains(AccessibleState.MULTISELECTABLE)) {
                ((AccessibleStateSet)object2).remove(AccessibleState.MULTISELECTABLE);
                this.firePropertyChange("AccessibleState", AccessibleState.MULTISELECTABLE, null);
            }
        }

        protected class AccessibleJListChild
        extends AccessibleContext
        implements Accessible,
        AccessibleComponent {
            private JList parent = null;
            private int indexInParent;
            private Component component = null;
            private AccessibleContext accessibleContext = null;
            private ListModel listModel;
            private ListCellRenderer cellRenderer = null;

            public AccessibleJListChild(JList jList, int n) {
                this.parent = jList;
                this.setAccessibleParent(jList);
                this.indexInParent = n;
                if (jList != null) {
                    this.listModel = jList.getModel();
                    this.cellRenderer = jList.getCellRenderer();
                }
            }

            public void addFocusListener(FocusListener focusListener) {
                AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
                if (accessibleContext instanceof AccessibleComponent) {
                    ((AccessibleComponent)((Object)accessibleContext)).addFocusListener(focusListener);
                } else {
                    Component component = this.getCurrentComponent();
                    if (component != null) {
                        component.addFocusListener(focusListener);
                    }
                }
            }

            public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
                AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
                if (accessibleContext != null) {
                    accessibleContext.addPropertyChangeListener(propertyChangeListener);
                }
            }

            public boolean contains(Point point) {
                AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
                if (accessibleContext instanceof AccessibleComponent) {
                    Rectangle rectangle = ((AccessibleComponent)((Object)accessibleContext)).getBounds();
                    return rectangle.contains(point);
                }
                Component component = this.getCurrentComponent();
                if (component != null) {
                    Rectangle rectangle = component.getBounds();
                    return rectangle.contains(point);
                }
                return this.getBounds().contains(point);
            }

            public AccessibleAction getAccessibleAction() {
                return this.getCurrentAccessibleContext().getAccessibleAction();
            }

            public Accessible getAccessibleAt(Point point) {
                AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
                if (accessibleContext instanceof AccessibleComponent) {
                    return ((AccessibleComponent)((Object)accessibleContext)).getAccessibleAt(point);
                }
                return null;
            }

            public Accessible getAccessibleChild(int n) {
                AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
                if (accessibleContext != null) {
                    Accessible accessible = accessibleContext.getAccessibleChild(n);
                    accessibleContext.setAccessibleParent(this);
                    return accessible;
                }
                return null;
            }

            public int getAccessibleChildrenCount() {
                AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
                if (accessibleContext != null) {
                    return accessibleContext.getAccessibleChildrenCount();
                }
                return 0;
            }

            public AccessibleComponent getAccessibleComponent() {
                return this;
            }

            public AccessibleContext getAccessibleContext() {
                return this;
            }

            public String getAccessibleDescription() {
                AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
                if (accessibleContext != null) {
                    return accessibleContext.getAccessibleDescription();
                }
                return null;
            }

            public int getAccessibleIndexInParent() {
                return this.indexInParent;
            }

            public String getAccessibleName() {
                AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
                if (accessibleContext != null) {
                    return accessibleContext.getAccessibleName();
                }
                return null;
            }

            public AccessibleRole getAccessibleRole() {
                AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
                if (accessibleContext != null) {
                    return accessibleContext.getAccessibleRole();
                }
                return null;
            }

            public AccessibleSelection getAccessibleSelection() {
                return this.getCurrentAccessibleContext().getAccessibleSelection();
            }

            public AccessibleStateSet getAccessibleStateSet() {
                AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
                AccessibleStateSet accessibleStateSet = accessibleContext != null ? accessibleContext.getAccessibleStateSet() : new AccessibleStateSet();
                accessibleStateSet = accessibleContext.getAccessibleStateSet();
                accessibleStateSet.add(AccessibleState.SELECTABLE);
                if (this.parent.hasFocus() && this.indexInParent == this.parent.getLeadSelectionIndex()) {
                    accessibleStateSet.add(AccessibleState.ACTIVE);
                }
                if (this.parent.isSelectedIndex(this.indexInParent)) {
                    accessibleStateSet.add(AccessibleState.SELECTED);
                }
                if (this.isShowing()) {
                    accessibleStateSet.add(AccessibleState.SHOWING);
                } else if (accessibleStateSet.contains(AccessibleState.SHOWING)) {
                    accessibleStateSet.remove(AccessibleState.SHOWING);
                }
                if (this.isVisible()) {
                    accessibleStateSet.add(AccessibleState.VISIBLE);
                } else if (accessibleStateSet.contains(AccessibleState.VISIBLE)) {
                    accessibleStateSet.remove(AccessibleState.VISIBLE);
                }
                accessibleStateSet.add(AccessibleState.TRANSIENT);
                return accessibleStateSet;
            }

            public AccessibleText getAccessibleText() {
                return this.getCurrentAccessibleContext().getAccessibleText();
            }

            public AccessibleValue getAccessibleValue() {
                return this.getCurrentAccessibleContext().getAccessibleValue();
            }

            public Color getBackground() {
                AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
                if (accessibleContext instanceof AccessibleComponent) {
                    return ((AccessibleComponent)((Object)accessibleContext)).getBackground();
                }
                Component component = this.getCurrentComponent();
                if (component != null) {
                    return component.getBackground();
                }
                return null;
            }

            public Rectangle getBounds() {
                if (this.parent != null) {
                    return this.parent.getCellBounds(this.indexInParent, this.indexInParent);
                }
                return null;
            }

            private Component getComponentAtIndex(int n) {
                if (n < 0 || n >= this.listModel.getSize()) {
                    return null;
                }
                if (this.parent != null && this.listModel != null && this.cellRenderer != null) {
                    Object object = this.listModel.getElementAt(n);
                    boolean bl = this.parent.isSelectedIndex(n);
                    boolean bl2 = this.parent.hasFocus() && n == this.parent.getLeadSelectionIndex();
                    return this.cellRenderer.getListCellRendererComponent(this.parent, object, n, bl, bl2);
                }
                return null;
            }

            private AccessibleContext getCurrentAccessibleContext() {
                Component component = this.getComponentAtIndex(this.indexInParent);
                if (component instanceof Accessible) {
                    return ((Accessible)((Object)component)).getAccessibleContext();
                }
                return null;
            }

            private Component getCurrentComponent() {
                return this.getComponentAtIndex(this.indexInParent);
            }

            public Cursor getCursor() {
                AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
                if (accessibleContext instanceof AccessibleComponent) {
                    return ((AccessibleComponent)((Object)accessibleContext)).getCursor();
                }
                Component component = this.getCurrentComponent();
                if (component != null) {
                    return component.getCursor();
                }
                Accessible accessible = this.getAccessibleParent();
                if (accessible instanceof AccessibleComponent) {
                    return ((AccessibleComponent)((Object)accessible)).getCursor();
                }
                return null;
            }

            public Font getFont() {
                AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
                if (accessibleContext instanceof AccessibleComponent) {
                    return ((AccessibleComponent)((Object)accessibleContext)).getFont();
                }
                Component component = this.getCurrentComponent();
                if (component != null) {
                    return component.getFont();
                }
                return null;
            }

            public FontMetrics getFontMetrics(Font font) {
                AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
                if (accessibleContext instanceof AccessibleComponent) {
                    return ((AccessibleComponent)((Object)accessibleContext)).getFontMetrics(font);
                }
                Component component = this.getCurrentComponent();
                if (component != null) {
                    return component.getFontMetrics(font);
                }
                return null;
            }

            public Color getForeground() {
                AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
                if (accessibleContext instanceof AccessibleComponent) {
                    return ((AccessibleComponent)((Object)accessibleContext)).getForeground();
                }
                Component component = this.getCurrentComponent();
                if (component != null) {
                    return component.getForeground();
                }
                return null;
            }

            public Locale getLocale() {
                AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
                if (accessibleContext != null) {
                    return accessibleContext.getLocale();
                }
                return null;
            }

            public Point getLocation() {
                if (this.parent != null) {
                    return this.parent.indexToLocation(this.indexInParent);
                }
                return null;
            }

            public Point getLocationOnScreen() {
                if (this.parent != null) {
                    Point point = this.parent.getLocationOnScreen();
                    Point point2 = this.parent.indexToLocation(this.indexInParent);
                    point2.translate(point.x, point.y);
                    return point2;
                }
                return null;
            }

            public Dimension getSize() {
                Rectangle rectangle = this.getBounds();
                if (rectangle != null) {
                    return rectangle.getSize();
                }
                return null;
            }

            public boolean isEnabled() {
                AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
                if (accessibleContext instanceof AccessibleComponent) {
                    return ((AccessibleComponent)((Object)accessibleContext)).isEnabled();
                }
                Component component = this.getCurrentComponent();
                if (component != null) {
                    return component.isEnabled();
                }
                return false;
            }

            public boolean isFocusTraversable() {
                AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
                if (accessibleContext instanceof AccessibleComponent) {
                    return ((AccessibleComponent)((Object)accessibleContext)).isFocusTraversable();
                }
                Component component = this.getCurrentComponent();
                if (component != null) {
                    return component.isFocusTraversable();
                }
                return false;
            }

            public boolean isShowing() {
                return this.parent.isShowing() && this.isVisible();
            }

            public boolean isVisible() {
                int n = this.parent.getFirstVisibleIndex();
                int n2 = this.parent.getLastVisibleIndex();
                if (n2 == -1) {
                    n2 = this.parent.getModel().getSize() - 1;
                }
                return this.indexInParent >= n && this.indexInParent <= n2;
            }

            public void removeFocusListener(FocusListener focusListener) {
                AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
                if (accessibleContext instanceof AccessibleComponent) {
                    ((AccessibleComponent)((Object)accessibleContext)).removeFocusListener(focusListener);
                } else {
                    Component component = this.getCurrentComponent();
                    if (component != null) {
                        component.removeFocusListener(focusListener);
                    }
                }
            }

            public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
                AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
                if (accessibleContext != null) {
                    accessibleContext.removePropertyChangeListener(propertyChangeListener);
                }
            }

            public void requestFocus() {
                AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
                if (accessibleContext instanceof AccessibleComponent) {
                    ((AccessibleComponent)((Object)accessibleContext)).requestFocus();
                } else {
                    Component component = this.getCurrentComponent();
                    if (component != null) {
                        component.requestFocus();
                    }
                }
            }

            public void setAccessibleDescription(String string) {
                AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
                if (accessibleContext != null) {
                    accessibleContext.setAccessibleDescription(string);
                }
            }

            public void setAccessibleName(String string) {
                AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
                if (accessibleContext != null) {
                    accessibleContext.setAccessibleName(string);
                }
            }

            public void setBackground(Color color) {
                AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
                if (accessibleContext instanceof AccessibleComponent) {
                    ((AccessibleComponent)((Object)accessibleContext)).setBackground(color);
                } else {
                    Component component = this.getCurrentComponent();
                    if (component != null) {
                        component.setBackground(color);
                    }
                }
            }

            public void setBounds(Rectangle rectangle) {
                AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
                if (accessibleContext instanceof AccessibleComponent) {
                    ((AccessibleComponent)((Object)accessibleContext)).setBounds(rectangle);
                }
            }

            public void setCursor(Cursor cursor) {
                AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
                if (accessibleContext instanceof AccessibleComponent) {
                    ((AccessibleComponent)((Object)accessibleContext)).setCursor(cursor);
                } else {
                    Component component = this.getCurrentComponent();
                    if (component != null) {
                        component.setCursor(cursor);
                    }
                }
            }

            public void setEnabled(boolean bl) {
                AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
                if (accessibleContext instanceof AccessibleComponent) {
                    ((AccessibleComponent)((Object)accessibleContext)).setEnabled(bl);
                } else {
                    Component component = this.getCurrentComponent();
                    if (component != null) {
                        component.setEnabled(bl);
                    }
                }
            }

            public void setFont(Font font) {
                AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
                if (accessibleContext instanceof AccessibleComponent) {
                    ((AccessibleComponent)((Object)accessibleContext)).setFont(font);
                } else {
                    Component component = this.getCurrentComponent();
                    if (component != null) {
                        component.setFont(font);
                    }
                }
            }

            public void setForeground(Color color) {
                AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
                if (accessibleContext instanceof AccessibleComponent) {
                    ((AccessibleComponent)((Object)accessibleContext)).setForeground(color);
                } else {
                    Component component = this.getCurrentComponent();
                    if (component != null) {
                        component.setForeground(color);
                    }
                }
            }

            public void setLocation(Point point) {
                if (this.parent != null && this.parent.contains(point)) {
                    JList.this.ensureIndexIsVisible(this.indexInParent);
                }
            }

            public void setSize(Dimension dimension) {
                AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
                if (accessibleContext instanceof AccessibleComponent) {
                    ((AccessibleComponent)((Object)accessibleContext)).setSize(dimension);
                } else {
                    Component component = this.getCurrentComponent();
                    if (component != null) {
                        component.setSize(dimension);
                    }
                }
            }

            public void setVisible(boolean bl) {
            }
        }
    }
}

